<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="ABOUTUS";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Hero section -->
      <section class="position-relative bg-dark pt-lg-4 pt-xl-5">
        <div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
          <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
        </div>
        <div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
          <div class="row justify-content-center pt-5">
            <div class="col-lg-12 col-xl-12 text-center pt-5 mt-1">
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">എൻ്റെ സൃഷ്ടിയെ കുറിച്ച്</h1>
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">About Us</h1>
			  
            </div>
          </div>
        </div>
        <div class="d-none d-lg-block" style="height: 480px;"></div>
        <div class="d-lg-none" style="height: 400px;"></div>
        <div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
          <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
            <svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
          </div>
        </div>
      </section>
	  
	  <!-- About -->
      <section class="container mb-5">
        <div class="row pt-5 mt-n5 mt-sm-0 mt-md-1 mt-lg-1 mt-xl-1">
          <div class="col-md-5 col-lg-5 col-xl-5">
            <div class="fs-sm mb-3 mt-5">What we</div>
            <h2 class="h2 mb-2">എന്താണ് 'എൻ്റെ സൃഷ്ടി ' ?</h2>
			<img class="mt-2 rounded-5 mx-auto d-block" src="https://cdn.entesrishti.com/assets/fe/img/950x950/img2.webp" alt="Image">
          </div>
          <div class="col-md-7 col-lg-7 col-xl-7 pt-1 pt-sm-2 pt-md-5">
            <p class="fs-md">പ്രകാശനം ചെയ്യുവാൻ കഴിയാതെ, അഥവാ പ്രോത്സാഹനം ലഭ്യമല്ലാത്ത കാരണത്താൽ സ്വന്തം കലാസൃഷ്ടികളുമായി ഒതുങ്ങിക്കൂടേണ്ടി വരുന്ന കലാകാരൻമാർക്ക് അവരുടെ നല്ല കലാ സൃഷ്ടിപ്പുകളെ യാതൊരുവിധ സാമ്പത്തിക ബാദ്ധ്യതകളുമില്ലാതെ ആസ്വാദകരുടെ മുൻപിൽ പ്രസാദനം ചെയ്യുന്ന രീതിയിൽ രൂപപ്പെടുത്തിയിട്ടുള്ള ഒരു വെബ്സൈറ്റാണ് ' എൻ്റെ സൃഷ്ടി'. എൻ്റെ സൃഷ്ടിയിലെ അംഗങ്ങളുടെ നല്ല കലാസൃഷ്ടികളെ ഈ വെബ്സൈറ്റിൽ പ്രസാദനം ചെയ്യുന്നു. പ്രസാദനം ചെയ്തിരിക്കുന്ന കലാസൃഷ്ടികളുടെ സൃഷ്ടികർത്താവിനെ കുറിച്ചുള്ള ലഘുവായ വിവരണം വെബ്സൈറ്റിൽ ഉൾപ്പെടുത്തിയിരിക്കുന്നതിനാൽ, ഭാവിയിൽ മനോഹരമായ അവസരങ്ങൾ എൻ്റെ സൃഷ്ടിയുടെ ആസ്വാദകരിൽ നിന്നും തേടിയെത്തുമ്പോൾ അത് കൃത്യമായും അവരിലെക്ക് തന്നെ എത്തിച്ചേരുവാൻ സഹായകമാകും. കലാ-സാഹിത്യത്തിന്റെ വിശാലമായ ആസ്വാദകരുള്ള ലോകത്തിലേക്ക് ഈ വെബ്സൈറ്റ് വാതിൽ തുറക്കുന്നതിനാൽ വിദൂരമല്ലാത്ത ഭാവിയിൽ പ്രസാദകർക്കോ, ദൃശ്യ-ശ്രവ്യമാധ്യമങ്ങളിൽ പ്രവർത്തിക്കുന്നവർക്കോ 'എൻ്റെ സൃഷ്ടി' യിലെ സൃഷ്ടികർത്താക്കൾക്ക് പുതു അവസരങ്ങൾ പ്രദാനം ചെയ്യുവാൻ കഴിയും. സാമ്പത്തിക ബുദ്ധിമുട്ടോ, പ്രസാദനമില്ലായ്മയോ, ഉന്നത നിലവാരത്തിലുള്ള കലാസൃഷ്ടികളുടെ അനിവാര്യതയോ ഒന്നും കലാകാരൻമാർക്ക് ഇവിടെ ഒരു തടസ്സമാകുന്നില്ല. 'എൻ്റെ സൃഷ്ടി' വെബ്സൈറ്റിന്റെ അണിയറ പ്രവർത്തകർ വെബ്സൈറ്റിനെ പടിപടിയായി ആസ്വാദക ലോകത്തിന്റെ വിശാലതലങ്ങളിൽ എത്തിക്കുന്നതിനുള്ള തീവ്ര പരിശ്രമത്തിലാണ്. ഓരോ സൃഷ്ടികർത്താവിനെ കുറിച്ചുള്ള വിവരണം, അവരുടെ കലാ - സാഹിത്യ പശ്ചാത്തലം, കലാസംഭാവനകൾ, തെരെഞ്ഞെടുത്ത കഥകൾ - ചിന്തകൾ എന്നിങ്ങനെ രീതിയിൽ ആണ് വെബ്സൈറ്റ് ഡിസൈൻ ചെയ്തിരിക്കുന്നത്. ഓരോ കഥാകാരനും പ്രത്യേകം പേജുകൾ ഉള്ളതിനാൽ കഥാകൃത്തിന്റെ പേരു വച്ച് തെരെഞ്ഞെടുക്കാനും, അതോടൊപ്പം കഥ, കവിത, ചിത്രങ്ങൾ എന്നിങ്ങനെ തെരെഞ്ഞെടുക്കാനും ആസ്വാദകർക്ക് സ്വാതന്ത്ര്യമുണ്ട്. സാധ്യമായ എല്ലാ രീതിയിലും ഓരോ കലാകാരനേയും ആസ്വാദകരിലേക്ക് എത്തിക്കുവാൻ തക്കവണ്ണം ' എൻ്റെ സൃഷ്ടി' ക്രമീകരിച്ചിട്ടുണ്ട്. എൻ്റെ സൃഷ്ടിയിൽ താങ്കളുടെ അനുഗമനവും വിലയേറിയ അഭിപ്രായങ്ങളും പ്രതീക്ഷിച്ചുകൊള്ളുന്നു</p>
          </div>
        </div>
      </section>
	  
	  
	  <!-- About -->
      <section class="container mb-5">
        <div class="row pt-5 mt-n5 mt-sm-0 mt-md-1 mt-lg-1 mt-xl-1">
          <div class="col-md-5 col-lg-5 col-xl-5">
            <div class="fs-sm mb-3 mt-5">Who we</div>
            <h2 class="h2 mb-2">എന്തിനാണ് 'എൻ്റെ സൃഷ്ടി ' ?</h2>
			<img class="mt-2 rounded-5 mx-auto d-block" src="https://cdn.entesrishti.com/assets/fe/img/500x650/img2.webp" alt="Image">
          </div>
		  <div class="col-md-7 col-lg-7 col-xl-7 pt-1 pt-sm-2 pt-md-5">
            <p class="fs-lg"><strong>പ്രധാനമായും രണ്ട് ലക്ഷ്യങ്ങളെസി മുൻനിർത്തിയാണ് 'എൻ്റെ സൃഷ്ടി' വെബ്സൈറ്റ് വിഭാവനം ചെയ്തിരിക്കുന്നത്.</strong></p>
            <p class="fs-md">1. സ്വന്തം കലാസൃഷ്ടികൾക്ക് വലിയൊരു സഹൃദയലോകത്തിന് മുൻപിൽ പ്രസാദനം: കലാകാരൻമാർക്ക് തങ്ങളുടെ കലാസൃഷ്ടികളെ - കഥകൾ, കവിതകൾ, ചിത്രരചനകൾ, ഫ്രെയിമിൽ പതിഞ്ഞ ചിത്രങ്ങൾ, ചിന്തകൾ എന്നിങ്ങനെ - യാതൊരു സാമ്പത്തിക ബാദ്ധ്യതകളുടേയോ മറ്റ് തടസ്സങ്ങളോ ഇല്ലാതെ, കൂടുതൽ സാധ്യതകളുള്ള ഒരു ഓൺലൈൻ പ്ലാറ്റ്ഫോമിൽ പ്രസിദ്ധപ്പെടുത്തി, അനേകം വായനക്കാരുടെ മുന്നിലേക്ക് അനാവൃതരാകാനുള്ള ഒരു സംരംഭമാണിത്.ഓൺലൈൻ മാധ്യമങ്ങൾ കാലഘട്ടത്തിന്റെ ഘടകമായതിനാലും പരക്കെ പ്രചാരുള്ളതിനാലും , കലാകാരൻമാർക്ക് സഹൃദയരുടെ വിശാലമായ ഒരു ലോകത്തിലേക്ക് വേഗത്തിൽ എത്തപ്പെടുവാൻ സാധിക്കുന്നു. ചെറുതും, വളർന്നു വരുന്നതുമായ ഏതൊരു കലാകാരനേയും പ്രോത്സാഹിപ്പിക്കുക എന്ന ഒരൊറ്റ ലക്ഷ്യം അതാണ് 'എൻ്റെ സൃഷ്ടി'യെ അണിയിച്ചൊരുകുവാൻ ഞങ്ങളെ പ്രേരിപ്പിച്ചത്. ഒപ്പം " ഓരോ രചയിതാവിനും സ്വന്തമായി ഒരു വെബ്സൈറ്റ്." ആ ഒരു സ്വപ്നവും ഇവിടെ സാക്ഷാത്ക്കരിക്കപ്പെടുകയാണ്.</p>
            <p class="fs-md">2. ഓൺലൈൻ വായനയുടെ പുതിയ ഒരു ലോകം:അരങ്ങ് അടക്കിവാഴുന്നവരുടെ മാത്രമല്ല അറിയപ്പെടാതെ പോയ വലിയൊരു കൂട്ടം കലാകാരൻമാരുടെ ചരിത്രമുണ്ട് നമ്മുടെ ഭൂതകാലത്തിനും വർത്തമാന കാലത്തിനും. അങ്ങനെയുള്ള കലാകാരൻമാരുടേയും ഉത്തമ സൃഷ്ടികളെ ആസ്വദിക്കാനുള്ള ഒരു ബൃഹത്തായ - മഹത്തായ സംരംഭംസ്വന്തം അഭിരുചിക്കനുസൃതമായി എത് വിഭാഗത്തിലുള്ള കലാസൃഷ്ടികളേയും ഒരൊറ്റ പ്ലാറ്റ്ഫോമിൽ നിന്നും തെരെഞ്ഞെടുത്ത് ആസ്വദിക്കുവാൻ ഈ ഒരൊറ്റ പ്ലാറ്റ്ഫോമിനു കഴിയും. ആസ്വാദകർക്ക് സൃഷ്ടികളെ കുറിച്ചുള്ള അവരുടെ അഭിപ്രായങ്ങൾ നേരിട്ട് സൃഷ്ടികർത്താവിനെ അറിയിക്കാനുള്ള സൗകര്യം, പുതിയ രചയിതാക്കളുടെ ചിത്രങ്ങളും വിവരങ്ങളും വെബ്സൈറ്റിന്റെ മുഖതാളിൽ തന്നെ ലഭ്യമായതിനാൽ വായനക്കാരന് തെരെഞ്ഞെടുപ്പ് എളുപ്പമാക്കുന്നതിനും, ഇങ്ങനെ ധാരാളം ഉപാധികൾ സൃഷ്ടിയിൽ ഉൾപ്പെടുത്തിയിരിക്കുന്നു. അതല്ലെങ്കിൽ വെബ്സൈറ്റിനുള്ളിൽ കടന്ന് താൽപര്യമുള്ള രചയിതാക്കളുടെ സൃഷ്ടികൾ തെരെഞ്ഞെടുത്ത് വായിക്കാം. ചുരുക്കിപ്പറഞ്ഞാൽ, ഏതൊരു വായനക്കാരനും തെരെഞ്ഞെടുപ്പിന്റെ പൂർണ്ണ സ്വാതന്ത്ര്യം; വൈവിധ്യമാർന്ന സൃഷ്ടി വിഭവങ്ങൾ, നവ്യ അനുഭവാസ്വാദനം എൻ്റെ സൃഷ്ടിയിൽ.</p>
          </div>
		</div>
      </section>
	  
	  <!-- About -->
      <section class="container mb-5">
        <div class="row pt-5 mt-n5 mt-sm-0 mt-md-1 mt-lg-1 mt-xl-1">
          <div class="col-md-5 col-lg-5 col-xl-5">
            <div class="fs-sm mb-3 mt-5">How we</div>
            <h2 class="h2 mb-2">എങ്ങനെയാണ് 'എൻ്റെ സൃഷ്ടി' ?</h2>
		  </div>
          <div class="col-md-7 col-lg-7 col-xl-7 pt-1 pt-sm-2 pt-md-5">
            <p class="fs-lg"><strong>എങ്ങനെയാണ് സൃഷ്ടിയിലേക്ക് പ്രവേശനം ?</strong></p>
            <p class="fs-md">https://www.entesrishti.com എന്ന 'എൻ്റെ സൃഷ്ടി' വെബ്സൈറ്റിന്റെ ,ലോഗിൻ പേജ് സന്ദർശിച്ചു നിങ്ങൾക് സ്വന്തമായി വെബ്സൈറ്റ് രജിസ്റ്റർ ചെയ്യുന്നതിനുള്ള അപേക്ഷ ഓൺലൈനായി സമർപ്പിക്കാം. 24 മണിക്കൂറിനുള്ളിൽ നിങ്ങളുടെ മെയിലിലേക്ക് നിങ്ങളുടെ അക്കൗണ്ട് ആക്ടിവറ്റ് ചെയ്തു കൊണ്ടുള്ള സ്ഥിരീകരണ മെയിൽ എത്തുന്നതായിരിക്കും. തുടർന്ന് നിങ്ങൾ വെബ്സൈറ്റിന് വേണ്ടി തയ്യാറാക്കിയ ലോഗിൻ ഐഡിയും പാസ്സ് വെർഡും ഉപയോഗിച്ചു വെബ്സൈറ്റ് ലോഗിൻ ചെയ്തു നിങ്ങൾക് നിങ്ങളുടെ സ്വന്തം വെബ്സൈറ്റ് ഉപയോഗിച്ചു തുടങ്ങാം. നിങ്ങളുടെ എഴുത്തുകളും മറ്റു സൃഷ്ടികളും പോസ്റ്റ് ചെയ്തു തുടങ്ങാം. ഇതിനോടൊപ്പം 'എൻ്റെ സൃഷ്ടി'യുടെ ഫേസ്ബുക് പേജിലും/ഗ്രുപ്പിലും നിങ്ങൾക് ചേരാവുന്നതാണ്. (ലിങ്ക്: https://www.facebook.com/groups/1391756037519571/ )</p>
          </div>
        </div>
      </section>
	  
	  
	  <!-- About -->
      <section class="container mb-5">
        <div class="row pt-5 mt-n5 mt-sm-0 mt-md-1 mt-lg-1 mt-xl-1">
          <div class="col-md-5 col-lg-5 col-xl-5">
            <div class="fs-sm mb-3 mt-5">Writer earn money?</div>
            <h2 class="h2 mb-2">എൻ്റെ സൃഷ്ടിയിലൂടെ എഴുത്തുകാരന് സാമ്പത്തിക വരുമാനം എങ്ങനെ?</h2>
			<img 
			  src="<?php echo $cdn; ?>/img.php?src=aboutus/image.png&webp=1" width="600" height="650"
			  srcset="
				<?php echo $cdn; ?>/img.php?src=aboutus/image.png&w=576&webp=1 576w,
				<?php echo $cdn; ?>/img.php?src=aboutus/image.png&w=768&webp=1 768w,
				<?php echo $cdn; ?>/img.php?src=aboutus/image.png&w=992&webp=1 992w,
				<?php echo $cdn; ?>/img.php?src=aboutus/image.png&w=1200&webp=1 1200w
			  "
			  sizes="(max-width: 575px) 100px, 
					 (max-width: 767px) 540px, 
					 (max-width: 991px) 720px, 
					 (max-width: 1199px) 960px, 
					 1140px"
			  class="mt-2 rounded-5 mx-auto d-block"
			  alt="Writer earn money?" loading="lazy">
		  </div>
          <div class="col-md-7 col-lg-7 col-xl-7 pt-1 pt-sm-2 pt-md-5">
            <p class="fs-md">എൻ്റെ സൃഷ്ടിയുടെ നാലാംഘട്ട അപ്ഡേഷൻ സമയത്ത് അവതരിപ്പിച്ച ഒരു ഫീച്ചർ ആണ്, എൻ്റെ സൃഷ്ടിയിൽ കലാസൃഷ്ടികൾ പബ്ലിഷ് ചെയ്യുന്ന സൃഷ്ടികർത്താക്കൾക്ക് അതിലൂടെ വരുമാനം സാധ്യമാക്കണം. ധാരാളം ഓൺലൈൻ പ്ലാറ്റ്ഫോമുകൾ ഈ കാലയളവിൽ ലഭ്യമാണ്. അവിടെ എല്ലാം വളർന്നു വരുന്ന ധാരാളം എഴുത്തുകാർ അവരുടെ സൃഷ്ടികൾ പ്രദർശിപ്പിക്കുന്നുണ്ട്. സൗജന്യമായി എല്ലാരും വായിച്ചിട്ട് പോകുന്നു. അതിൽ നിന്നും സൃഷ്ടികർത്താവിന് യാതൊരുവിധ സാമ്പത്തിക നേട്ടവും ഇല്ല. മാത്രവുമല്ല ഈ കഥകൾ എല്ലാം കൂടി പുസ്തക രൂപത്തിൽ പബ്ലിഷ് ചെയ്തു വിപണനത്തിനു ഇറക്കാമെന്ന് വച്ചാൽ, പ്രിൻ്റിങ്ങിന് പതിനായിരങ്ങളോ ലക്ഷങ്ങളോ ചിലവും വരും. ഈ ഒരു കാരണം കൊണ്ട് മാത്രം ഭൂരിഭാഗം വരുന്ന എഴുത്തുകാരും തങ്ങളുടെ കലാസൃഷ്ടികൾ മുഖാന്തിരം യാതൊരു നേട്ടവും ഇല്ലാതെ, പബ്ലിക് പ്ലാറ്റ്ഫോമുകളിൽ നിന്നും ലഭിക്കുന്ന കമൻ്റുകൾ വായിച്ചു സായാജ്യം അടയുന്നു.</p>
            <p class="fs-md">ഇവിടെയാണ് എൻ്റെ സൃഷ്ടി പുതിയൊരു പദ്ധതിയുമായി മുന്നിലേക്ക് വരുന്നത്.</p>
            <p class="fs-md">സ്വന്തം എഴുത്തുകൾ പുസ്തകരൂപത്തിൽ പബ്ലിഷ് ചെയ്യാൻ താല്പര്യമുള്ള ഏതൊരു എഴുത്തുകാരൻ്റെയും സൃഷ്ടികളെ, എൻ്റെ സൃഷ്ടി പുസ്തകരൂപത്തിൽ ആക്കി പബ്ലിഷ് ചെയ്യുന്നു. പബ്ലിഷ് ചെയ്യുക മാത്രമല്ല, ആ പുസ്തകങ്ങളെ വിപണിയിൽ എത്തിച്ചു വില്പനയ്ക്ക് ഉള്ള സാഹചര്യം ഒരുക്കുന്നു. അങ്ങനെ പുസ്തകങ്ങൾ വിറ്റുകിട്ടുന്ന തുക സൃഷ്ടികർത്താവിന് കൈമാറുന്നു.</p>
            <p class="fs-md">ഇത്രയും സൗകര്യങ്ങൾ ഒരുക്കുന്ന ലോകത്തിലെ തന്നെ ആദ്യത്തെ ഓൺലൈൻ പ്ലാട്ഫോം എൻ്റെ സൃഷ്ടി ആയിരിക്കും.</p>
            <p class="fs-md">കൂടുതൽ വിവരങ്ങൾ എൻ്റെ സൃഷ്ടി വെബ്സൈറ്റിൻ്റെ നാലാം പതിപ്പിൽ നേരിട്ട് കാണാം. അതുകൊണ്ട് ഇനി താമസിപ്പിക്കണ്ട, നിങ്ങളുടെ അധ്വാനത്തിന് വില ഇല്ലാതെ പോകരുത്. നിങ്ങളുടെ, സാമ്യതകളില്ലാത്ത പുത്തൻ സൃഷ്ടികളുമായി ഒരുങ്ങിയിരിക്കു...എൻ്റെ സൃഷ്ടി നിങ്ങളുടെ പ്രസാധനം എന്ന ആഗ്രഹ പൂർത്തീകരണത്തിനും ഒപ്പം സമ്പാദനതിനും നിങ്ങളോടൊപ്പം ഉണ്ട്.</p>
            <p class="fs-md">എൻ്റെ സൃഷ്ടിയുടെ വളർച്ചയുടെ നാഴിക കല്ലുകൾ: ഒന്നാം പതിപ്പ് : എഴുത്തുകാർക്ക് സ്വന്തമായി ഒരു വെബ്സൈറ്റ് എന്ന ആശയത്തോടെ www.entesrishti.com എന്ന വെബ്സൈറ്റ് ലോഞ്ച് ആയി.</p>
            <p class="fs-md">രണ്ടാം പതിപ്പ് : വെബ്സൈറ്റിൻ്റെ മുഖം മിനുക്കി കൂടുതൽ ചാരുതയോടെ അപ്ഡേറ്റ് ആയി.</p>
            <p class="fs-md">മൂന്നാം പതിപ്പ് : വെബ്സൈറ്റിൻ്റെ മുഖം മിനുക്കി കൂടുതൽ ചാരുതയോടെ അപ്ഡേറ്റ് ആയി.</p>
            <p class="fs-md">നാലാം പതിപ്പ് : വെബ്സൈറ്റിൻ്റെ മുഖം മിനുക്കി കൂടുതൽ ചാരുതയോടെ അപ്ഡേറ്റ് ആയി.</p>
            <p class="fs-md">അഞ്ചാം പതിപ്പ് : സൃഷ്ടികർത്താക്കൾക്ക് അവരുടെ പുസ്തകങ്ങളെയൊ സ്ഥാപനങ്ങളെയൊ കുറിച്ച് വളരെ കുറഞ്ഞ ചെലവിൽ പരസ്യം ചെയ്യുന്നതിന് പരസ്യം ചെയ്യാനുള്ള സൗകര്യത്തോടെ അപ്ഡേഷൻ. ഒപ്പം എൻ്റെ സൃഷ്ടി, ഡെസ്ക് ടോപ്പിൽ എന്നപോലെ വേഗത്തിൽ മൊബൈൽ, ടാബ്‌ലറ്റ് തുടങ്ങിയ ഇലക്ട്രോണിക് മാധ്യമ വേഗത്തിൽ ലഭ്യമാക്കുവാൻ എൻ്റെ സൃഷ്ടിയുടെ ആൻഡ്രോയ്ഡ് / ഐഒഎസ് ആപ്ലിക്കേഷൻ ലോഞ്ച് ചെയ്യുന്നു. ഇതിനോടൊപ്പം വെബ്സൈറ്റ് കൂടുതൽ ചാരുതയിൽ പ്രത്യക്ഷമാകുന്നു.</p>
            <p class="fs-md">ആറാം പതിപ്പ്: ഉടൻ വെബ്സൈറ്റ് - മൊബൈൽ ആപ്ലിക്കേഷനുകൾ കൂടുതൽ ചാരുതയോടെ, എഴുത്തുകാർക്ക് സാമ്പത്തിക വരുമാനം ഉണ്ടാകുന്ന പുതിയ മാർഗങ്ങളുമായി നിങ്ങളുടെ മുന്പിലെത്തും. കാത്തിരിക്കുക.</p>
          </div>
        </div>
      </section>
	  
	  <!-- About -->
      <section class="container mb-5">
        <div class="row pt-5 mt-n5 mt-sm-0 mt-md-1 mt-lg-1 mt-xl-1">
          <div class="col-md-5 col-lg-5 col-xl-5">
            <div class="fs-sm mb-3 mt-5">Should I advertise?</div>
            <h2 class="h2 mb-2">എൻ്റെ സൃഷ്ടിയിൽ എന്തിന് പരസ്യം ചെയ്യണം?</h2>
		  </div>
          <div class="col-md-7 col-lg-7 col-xl-7 pt-1 pt-sm-2 pt-md-5">
            <p class="fs-md">ഏതൊരു ഉത്പന്നത്തിൻ്റെ ഗുണമേന്മ പരസ്യങ്ങൾ തീരുമാനിക്കുന്ന ഈ ലോകത്ത്, തങ്ങളുടെ സൃഷ്ടികളെ, പുസ്തകങ്ങളെ, സ്ഥാപനങ്ങളെ, വലിയ ഒരു സമൂഹത്തിൻ്റെ മുൻപിൽ പ്രദർശിപ്പിക്കാൻ എല്ലാവരും ആഗ്രഹിക്കുന്നതാണ്. പക്ഷേ അവിടെ എല്ലാവരും നേരിടുന്ന പ്രധാന വിഷമം സാമ്പത്തിക ചെലവുകൾ ആണ്. ഇവിടെയാണ് എൻ്റെസൃഷ്ടിയുടെ പ്രാധാന്യം. എൻ്റെസൃഷ്ടി, എല്ലാവർക്കും ഏറ്റവും കുറഞ്ഞ ചിലവിൽ വലിയൊരു സമൂഹത്തിന് മുൻപിൽ നിങ്ങളുടെ പ്രോഡക്ടുകളെ പരസ്യം ചെയ്യാൻ സഹായിക്കുന്നു.</p>
            <p class="fs-md">എൻ്റെ സൃഷ്ടി.കോം എന്ന സംരംഭം തികച്ചും സാധാരണ എഴുത്തുകാരുടെ സൃഷ്ടികർമ്മത്തിനും വളർച്ചയ്ക്കും വേണ്ടി രൂപകല്പന ചെയ്തിട്ടുള്ളത് ആണ്. അതുകൊണ്ട്തന്നെ ഇന്ത്യയിലും പുറം രാജ്യങ്ങളിലും ഉള്ള ധാരാളം എഴുത്തുകാർ അവരുടെ എഴുത്തുകൾ ഇവിടെ പബ്ലിഷ് ചെയ്യുന്നു. അതുകൊണ്ട് തന്നെ ഇന്ത്യയിലും പുറത്തുമായി എഴുത്തുകാരുടെയും വായനക്കാരുടെയും വായനയെ സ്നേഹിക്കുന്നവരുടെയും ഒരു വലിയ സമൂഹം ഈ വെബ്സൈറ്റ് ദിനംപ്രതി സന്ദർശിക്കുന്നു. അതുകൊണ്ട് ഇവിടെ പ്രദർശിപ്പിക്കുന്ന പരസ്യങ്ങൾ ലക്ഷക്കണക്കിന് ആളുകളുടെ ശ്രദ്ധ ആകർഷിക്കുന്നു. അവർ കലയെ സ്നേഹിക്കുന്നവർ ആകയാൽ എഴുത്തുകാരുടെ സംരഭങ്ങളെ അവർ</p>
            <p class="fs-md">പ്രോത്സാഹിപ്പിച്ചുകൊണ്ടെയിരിക്കും. ഇത് എൻ്റെ സൃഷ്ടിയുടെ മാത്രം പ്രത്യേകത ആണ്. ഇവിടെ നിങ്ങളുടെ പരസ്യങ്ങൾ, കടലിന്നക്കരെയും ഇക്കരെയുമുള്ള ഒരു വലിയ കലാസ്വാദന ലോകത്തിന് മുൻപിൽ എത്തുന്നു.</p>
            <p class="fs-md">വളർന്നു വരുന്ന എഴുത്തുകാർക്ക് അവരുടെ സാമ്പത്തിക സ്ഥിതി അനുസരിച്ച്, ദിവസങ്ങളുടെ എണ്ണം അനുസരിച്ച്, അല്ലെങ്കിൽ ആഴ്ചകളുടെ എണ്ണം അനുസരിച്ച്, മാസങ്ങളുടെ എണ്ണം അനുസരിച്ച്, പരസ്യങ്ങളുടെ വലിപ്പം അനുസരിച്ച് തിരഞ്ഞെടുത്ത് പരസ്യം ചെയ്യാൻ അവസരം എൻ്റെ സൃഷ്ടി. കോം ഒരുക്കുന്നു. ഒപ്പം സീസൺ അനുസരിച്ച് ഡിസ്കൗണ്ട് ഓഫെറുകളും ലഭിക്കുന്നു.</p>
            <p class="fs-md">ഇത്രയും സൗകര്യങ്ങൾ ലഭ്യമാക്കുന്ന പരസ്യ പ്രസിദ്ധീകരണ പ്ലാറ്റ്ഫോം ഇതുവരെ ഉണ്ടായിട്ടുണ്ട് എന്ന് തോന്നുന്നില്ല.</p>
            <p class="fs-md">പരസ്യം ചെയ്യാൻ ഈ ലിങ്കിൽ ക്ലിക്ക് ചെയ്യുക.</p>
            </div>
        </div>
      </section>
	  
	  <!-- Team -->
      <section class="pt-5 mt-2 mt-xl-4 mt-xxl-5 mb-5">
        <div class="container pt-3 pt-sm-4 pt-lg-5 mt-xl-2 mt-xxl-3">
          <div class="fs-sm text-uppercase mb-3">Our team</div>
          <h2 class="display-6 pb-3 mb-lg-4">നമ്മുടെ നേതൃത്വം</h2>
          <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4">

            <?php
			mysqli_set_charset ($conn,'utf8'); 
			$team_q = "SELECT * FROM adminteam";
			$team_r = mysqli_query($conn, $team_q);
			while($team_run = mysqli_fetch_assoc($team_r)){
			$team_id = $team_run['id'];
			$team_name = $team_run['name'];
			$team_post = $team_run['post'];
			$team_profileimg = $team_run['profileimg'];
			?>
			<!-- Item -->
            <div class="col">
              <div class="card card-hover border-0 rounded-5 overflow-hidden">
                <img src="<?php echo $cdn; ?>/img.php?src=profileimages/team/adminteam/<?php echo $team_profileimg; ?>&w=404&webp=1" style="min-height:450px; max-height:450px; min-width:450px; max-width:450px;" alt="<?php echo $team_name; ?>">
                <div class="position-absolute top-0 start-0 w-100 h-100 opacity-0">
                  <div class="bg-dark position-absolute top-0 start-0 w-100 h-100 opacity-50"></div>
                  <div class="card-body d-flex flex-column justify-content-end h-100 position-relative z-2 text-center" data-bs-theme="dark">
                    <h3 class="h5 mb-1"><?php echo $team_name; ?></h3>
                    <p class="text-body mb-3"><?php echo $team_post; ?></p>
                    
                  </div>
                </div>
              </div>
            </div>
			<?php } ?>
	  
	  
	  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>