<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="CATEGORYS";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
	<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Hero slider -->
      
	  <!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5 mt-5 mb-5">

        <!-- Page title + filters -->
        <div class="row align-items-center gy-2 mb-4 pb-1 pb-sm-2 pb-lg-3 mt-5">
          <div class="col-lg-5">
            <h1 class="mb-lg-0">All Posts</h1>
          </div>
        </div>


        <?php
			mysqli_set_charset ($conn,'utf8');
			if (isset($_GET['pageno'])) 
			{
				$pageno = $_GET['pageno'];
			} else 
			{
				$pageno = 1;
			}
			$no_of_records_per_page = 15;
			$offset = ($pageno-1) * $no_of_records_per_page;
			mysqli_set_charset ($conn,'utf8');
			$total_pages_sql = "SELECT COUNT(*) FROM posts";
			$result = mysqli_query($conn,$total_pages_sql);
			$total_rows = mysqli_fetch_array($result)[0];
			$total_pages = ceil($total_rows / $no_of_records_per_page);
			$sql = "SELECT * FROM posts ORDER BY post_id DESC LIMIT $offset, $no_of_records_per_page";
			$res_data = mysqli_query($conn,$sql);
			while($row = mysqli_fetch_array($res_data)){
			$post_id 			= $row['post_id'];
			$post_userid 		= $row['post_userid'];
			$post_heading 		= $row['post_heading'];
			$post_date 			= $row['post_date'];
			$newdate			= date_create("$post_date");
			$post_category 		= $row['post_category'];
			$post_author 		= $row['post_author'];
			$post_image 		= $row['post_image'];
			$post_catcontent 	= strip_tags(substr($row['post_catcontent'],0,800));
			
			mysqli_set_charset ($conn,'utf8'); 
			$pu = "select * from user where id='$post_userid'";
			$pur = mysqli_query($conn, $pu);
			while($peu = mysqli_fetch_assoc($pur)){
			$id 			= $peu['id'];
			$name 			= $peu['name'];
			$profileimg 	= $peu['profileimg'];
			}
			?>	
		
		<div class="article-feed mt-3">
			<!-- Post -->
			<article class="article row g-0 border-0 mb-4">
			  <a class="col-sm-5 col-lg-4 bg-repeat-0 bg-size-cover bg-position-center rounded-5" href="item.php?id=<?php echo $post_id; ?>" style="background-image: url(<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1&w=430); min-height: 16rem" aria-label="Post image" onerror="this.onerror=null;this.src='<?php echo $cdn; ?>/postimages/93638530_543295899953416_965330267170375563_n.webp'"></a>
			  <div class="col-sm-7 col-lg-8">
				<div class="pt-4 pb-sm-4 ps-sm-4 pe-lg-4">
				  <h3>
					<a href="item.php?id=<?php echo $post_id; ?>"><?php echo $post_heading; ?></a>
				  </h3>
				  <p class="d-sm-none d-md-block"><?php echo $post_catcontent; ?> ...</p>
				  <div class="d-flex flex-wrap align-items-center mt-n2">
					<a class="nav-link text-body-secondary fs-sm fw-normal p-0 mt-2 me-3" href="#">
						<?php
						$sql8="select * from srishtilike WHERE postid = $post_id";
						$result8=mysqli_query($conn,$sql8);
						$row8=mysqli_num_rows($result8);
						?>
						<?php echo $row8 ?>
					  <i class="bi bi-hand-thumbs-up fs-lg ms-1"></i>
					</a>
					<a class="nav-link text-body-secondary fs-sm fw-normal d-flex align-items-end p-0 mt-2" href="#">
						<?php
						$sql12="select * from srishticomment WHERE postid = $post_id";
						$result12=mysqli_query($conn,$sql12);
						$row12=mysqli_num_rows($result12);
						?>
					  <?php echo $row12 ?>
					  <i class="bi bi-chat fs-lg ms-1"></i>
					</a>
					<span class="fs-xs opacity-20 mt-2 mx-3">|</span>
					<span class="fs-sm text-body-secondary mt-2"><?php echo date_format($newdate,"d-M-Y"); ?></span>
					<span class="fs-xs opacity-20 mt-2 mx-3">|</span>
					<a class="badge text-nav fs-xs border mt-2" href="category.php?catid=<?php echo $catidnew; ?>"><?php echo $post_category; ?></a>
				  </div>
				</div>
			  </div>
			</article>
		</div>
		<?php } ?>
		
		<!-- status elements -->
		<div class="scroller-status">
		  <div class="infinite-scroll-request loader-ellips">
			<img src="Eclipse-1s-200px.gif" class="mx-auto d-block" alt="entesrisht loading">
		  </div>
		  <div class="infinite-scroll-last alert alert-info" role="alert">
			  End of content
		  </div>
		  <div class="infinite-scroll-error alert alert-info" role="alert">
			  No more pages to load
		  </div>
		</div>
			
		<!-- pagination has path -->
		<p class="pagination">
			<a class="pagination__next" href="category.php<?php echo "?catid=$catdisplay&pageno=".($pageno + 1) ?>">Next page</a>
		</p>
	  
	  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
	<script src="https://unpkg.com/infinite-scroll@4/dist/infinite-scroll.pkgd.min.js"></script>
	<script>
		// init Infinite Scroll
		$('.article-feed').infiniteScroll({
		  path: '.pagination__next',
		  append: '.article',
		  status: '.scroller-status',
		  hideNav: '.pagination',
		  
		});
	</script>
  </body>
</html>