<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="CONTACTUS";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Page title + Сontact form -->
      <section class="container pt-5 pb-lg-2 pb-xl-4 py-xxl-5 my-5">

        <div class="row pb-1 pb-sm-3 pb-lg-4 mt-5">
          <div class="col-lg-4 pe-xxl-4 mt-3">

            <!-- Page title -->
            <h1 class="display-2">Contacts</h1>
            <p class="fs-md pb-4 mb-0 mb-sm-2">www.entesrishti.com വെബ്സൈറ്റ്നെക്കുറിച്ചുള്ള നിങ്ങളുടെ ആശയങ്ങളും ചിന്തകളും ഞങ്ങൾ വിലമതിക്കുന്നു, സൈറ്റിനെ മികച്ചതാക്കാൻ ഞങ്ങളെ സഹായിക്കുന്നതിനായി ഞങ്ങൾ ഞങ്ങളുടെ ഉപയോക്താക്കളെ ആശ്രയിക്കുന്നു. നിങ്ങൾക്ക് എന്തെങ്കിലും ചിന്തകൾ, പ്രശ്നങ്ങൾ അല്ലെങ്കിൽ നിർദേശങ്ങൾ ഉണ്ടെങ്കിൽ, തുടർന്ന് നിങ്ങളുടെ നിർദ്ദേശങ്ങൾ അയയ്ക്കുക</p>
            <p class="fs-md pb-4 mb-0 mb-sm-2">Get in touch with us by completing the below form or call us now</p>
          </div>
          <div class="col-lg-8 col-xl-7 offset-xl-1">

            <!-- Contact form -->
            <form class="row g-4 needs-validation" novalidate>
              <div class="col-sm-6">
                <label class="form-label fs-base" for="name">Name</label>
                <input class="form-control form-control-lg" type="text" placeholder="Your name" required id="name">
                <div class="invalid-feedback">Please enter your name!</div>
              </div>
              <div class="col-sm-6">
                <label class="form-label fs-base" for="email">Email</label>
                <input class="form-control form-control-lg" type="email" placeholder="Email address" required id="email">
                <div class="invalid-feedback">Please provide a valid email address!</div>
              </div>
              <div class="col-sm-6">
                <label class="form-label fs-base" for="phone">Phone</label>
                <input class="form-control form-control-lg" type="text" placeholder="Phone number" id="phone">
              </div>
              <div class="col-sm-6">
                <label class="form-label fs-base" for="location">Location</label>
                <select class="form-select form-select-lg" id="location">
                  <option value="All locations">All locations</option>
                  <option value="Asia and Pacific">Asia and Pacific</option>
                  <option value="Central Europe">Central Europe</option>
                  <option value="Eastern Europe">Eastern Europe</option>
                  <option value="North America">North America</option>
                  <option value="South America">South America</option>
                </select>
              </div>
              <div class="col-sm-12">
                <label class="form-label fs-base" for="message">How can we help?</label>
                <textarea class="form-control form-control-lg" rows="5" placeholder="Enter your message here..." required id="message"></textarea>
                <div class="invalid-feedback">Please enter your message!</div>
              </div>
              <div class="col-sm-12">
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="checkbox" id="agree">
                  <label class="form-check-label" for="agree">I agree to the <a class="nav-link d-inline fs-normal text-decoration-underline p-0" href="#">Terms &amp; Conditions</a></label>
                </div>
              </div>
              <div class="col-sm-12 pt-2">
                <button class="btn btn-lg btn-primary" type="submit">Send a request</button>
              </div>
            </form>
          </div>
        </div>
      </section>
	  
	  <section>
		<!-- Contact details -->
        <div class="container border-top pb-sm-3 pt-4 mb-5">
          <div class="row g-4 pt-2">

            <!-- Address -->
            <div class="col-4 pb-2">
              <h4 class="mb-lg-4">Address</h4>
              <p class="fs-lg fw-medium pb-3 mb-3">LR Towers, SJRRA 104, <br>S Janatha Rd, Kochi, Kerala <br>PIN: 682025</p>
              <a class="btn btn-primary" href="#">
                <i class="ai-map-pin me-1"></i>
                Get directions
              </a>
            </div>

            <!-- Phone -->
            <div class="col-4 pb-2">
              <h4 class="mb-lg-4">Phone</h4>
              <ul class="list-unstyled mb-0">
                <li class="pb-1 mb-2">
                  <a class="nav-link fs-lg p-0 fs-lg fw-medium">+91 95672 88591</a>
                </li>
              </ul>
            </div>

            <!-- Email -->
            <div class="col-4">
			  <h4 class="mb-lg-4 mb-3">Email</h4>
			  
              <h6 class="mb-lg-4">അന്വേഷണങ്ങൾ: <span>info@entesrishti.com</span></h6>
              <h6 class="mb-lg-4 mt-3">ബില്ലിംഗ്: <span>billing@entesrishti.com</span></h6>
              <h6 class="mb-lg-4 mt-3">പിന്തുണ: <span>support@entesrishti.com</span></h6>
              
            </div>
          </div>
        </div>
      </section>
	  
	  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>