<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="Home";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  
	  <!-- Hero section -->
      <section class="position-relative bg-dark pt-lg-4 pt-xl-5">
        <div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
          <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
        </div>
        <div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
          <div class="row justify-content-center pt-5">
            <div class="col-lg-9 col-xl-8 text-center pt-5 mt-1">
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">Cookie Policy</h1>
			  <p class="text-white opacity-70 fs-xl">Effective Date: May 1, 2025</p>
            </div>
          </div>
        </div>
        <div class="d-none d-lg-block" style="height: 480px;"></div>
        <div class="d-lg-none" style="height: 400px;"></div>
        <div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
          <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
            <svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
          </div>
        </div>
      </section>
	  
	  <!-- Project showcase -->
      <section class="container pt-lg-1 pt-xl-1 pt-xxl-1">
        <div class="row py-sm-3 py-md-4 py-lg-5">

          <!-- Sticky sidebar with brief -->
          <aside class="col-md-3 col-lg-3 d-none d-md-block d-lg-block" style="margin-top: -125px;">
            <div class="d-flex d-md-block flex-wrap position-sticky top-0" style="padding-top: 130px;">
              <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
               <h2 class="fs-base fw-normal text-body-secondary mb-5"></h2>
			   <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1">1. What are Cookies?</li>
                  <li class="d-block py-1">2. How We Use Cookies</li>
                  <li class="d-block py-1">3. Managing Cookies</li>
                  <li class="d-block py-1">4. Third-Party Cookies</li>
                  <li class="d-block py-1">5. Updates to This Policy</li>
                  <li class="d-block py-1">6. Contact Us</li>
                </ul>
              </div>
			  <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
                <h2 class="fs-base fw-normal text-body-secondary mb-2">Use Full Links</h2>
                <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1"><a href="">Terms & Conditions</a></li>
                  <li class="d-block py-1"><a href="">Refund policy</a></li>
                  <li class="d-block py-1"><a href="">Privacy Policy</a></li>
                </ul>
              </div>
            </div>
          </aside>
		  
		  <!-- Description -->
          <div class="col-md-9 mb-5">
            <div class="ps-md-4 ps-lg-0">
				<p class="fs-lg">This Cookie Policy explains how entesrishti.com uses cookies and similar technologies to improve your experience on our website.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">1. What are Cookies?</h2>
				<p class="fs-lg">Cookies are small text files placed on your device to collect standard internet log information and visitor behavior. They help us personalize content and remember user preferences.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">2. How We Use Cookies</h2>
				<ul>
				  <li class="fs-lg">To remember your preferences and settings</li>
				  <li class="fs-lg">To understand how you use our website</li>
				  <li class="fs-lg">To analyze website traffic using tools like Google Analytics</li>
				  <li class="fs-lg">To improve user experience and functionality</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">3. Managing Cookies</h2>
				<p class="fs-lg">You can set your browser to refuse all or some browser cookies. Disabling cookies may affect the functionality of the website.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">4. Third-Party Cookies</h2>
				<p class="fs-lg">We may allow third-party services like Google or Facebook to place cookies to help deliver ads and analyze usage. These are governed by their own policies.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">5. Updates to This Policy</h2>
				<p class="fs-lg">We may update this Cookie Policy from time to time. Please revisit this page periodically for the latest version.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">6. Contact Us</h2>
				<p class="fs-lg">If you have any questions about our cookie use, email us at <strong>info@entesrishti.com / support@entesrishti.com</strong>.</p>
			</div>
		  </div>
		</section>
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>