<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="EBOOKSHOP";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/<?php echo $cdn; ?>/uploads/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/<?php echo $cdn; ?>/uploads/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Page container -->
      <div class="container py-5 mt-5 mb-lg-4 mb-xl-5">
	  
		<!-- Banner -->
        <section class="rounded-1 overflow-hidden mb-5" style="background-color: #e3e5e9;" data-bs-theme="light">
          <div class="row align-items-center g-0">
            <div class="col-md-6 offset-xl-1 text-center text-md-start">
              <div class="py-4 px-4 px-sm-5 pe-md-0 ps-xl-4">
                <p class="text-body fs-xs text-uppercase pt-3 pt-md-0 mb-3 mb-lg-4">Best selling</p>
                <h2 class="h1 pb-2 pb-xl-3">Cozy corner for the living room at a <span class="text-primary">discount up to 40%</span></h2>
                <a class="btn btn-sm btn-outline-dark" href="#" data-bs-theme="light">Explore</a>
              </div>
            </div>
            <div class="col-md-6 col-xl-5 d-flex justify-content-end">
              <img src="<?php echo $cdn; ?>/uploads/assets/img/shop/banner.jpg" width="491" alt="Banner">
            </div>
          </div>
        </section>
		
		<!-- Page title -->
        <div class="row pt-xl-3 mt-n1 mt-sm-0">
          <div class="col-lg-12 pt-lg-3">
            <h1 class="pb-2 pb-sm-3">Ebook Shop</h1>
          </div>
        </div>
        <div class="row pb-2 pb-sm-4">
		  <!-- Product grid -->
          <div class="col-lg-12">

            <!-- Active filters + Sorting -->
            <div class="d-flex align-items-start justify-content-between mb-4">
              <div class="me-3">
                
                <div class="collapse d-md-block" id="activeFilters">
                  <div class="pt-2 pt-md-0">
                    <a class="d-inline-block border rounded-pill fs-xs fw-medium text-body text-decoration-none py-1 px-2 me-2 mb-2" href="#">
                      <span class="d-inline-flex align-items-center text-nowrap px-1">
                        Free<i class="ai-circle-x fs-base ms-1"></i>
                      </span>
                    </a>
                    <a class="d-inline-block border rounded-pill fs-xs fw-medium text-body text-decoration-none py-1 px-2 me-2 mb-2" href="#">
                      <span class="d-inline-flex align-items-center text-nowrap px-1">
                        Paid<i class="ai-circle-x fs-base ms-1"></i>
                      </span>
                    </a>
                  </div>
                </div>
              </div>
              <div class="d-flex align-items-center flex-shrink-0 mb-2"><span class="text-body-secondary text-nowrap fs-sm">Sort by:</span>
                <select class="form-select form-select-flush py-0">
                  <option value="popular">Most popular</option>
                  <option value="low-high">Low-High price</option>
                  <option value="high-low">High-Low price</option>
                  <option value="rating">Average rating</option>
                  <option value="az">A-Z order</option>
                  <option value="za">Z-A order</option>
                </select>
              </div>
            </div>
			
			<div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-4 row-cols-xxl-4 g-4 mb-5">
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  <!-- Item -->
              <div class="col rounded-1">
                <div class="card-hover card-lifted position-relative bg-secondary rounded-1 p-2 border border-primary shadow-lg">
					<span class="badge bg-danger text-white position-absolute top-0 start-0 mt-3 ms-3">Free</span>
					<button class="btn btn-icon btn-sm btn-light bg-light border-0 rounded-circle position-absolute top-0 end-0 mt-3 me-3 z-5 opacity-0" type="button" aria-label="Add to Favorites">
						<i class="bi bi-heart fs-xl text-nav"></i>
					</button>
					<a class="d-block mb-3" href="#">
						<img class="d-block mx-auto mb-2 rounded-1" src="<?php echo $cdn; ?>/uploads/book/book_1623178866_SRISHTIBOOKCOVER.webp" width="300" height="330"alt="Product">
					</a>
					<div class="d-flex mb-1">
						<h3 class="h6 mb-0">
							<a href="#">Loft style lamp</a>
						</h3>
					</div>
					<div class="d-flex align-items-center">
						<span class="me-2"><i class="bi bi-currency-rupee"></i> 21.00</span>
						<del class="fs-sm text-body-secondary"><i class="bi bi-currency-rupee"></i> 35.00</del>
						<div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
							<a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
								<i class="bi bi-cart-plus"></i>
							</a>
						</div>
					</div>
				</div>
              </div>
			  
			  
			  
			  
			  
			  
			  
			  
			</div>  
			
		  </div>
		</div>
	</div>  
	  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>