<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="HOME";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/uploads/<?php echo $cdn; ?>/uploads/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/uploads/<?php echo $cdn; ?>/uploads/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
      <!-- slider -->
      <?php include('config/slider.php')?>
	  
	  <!-- Feature Slider -->
      <section class="container pt-5 mt-lg-3 mt-xl-4 mt-xxl-5 pb-5 mb-md-3 mb-lg-4 mb-xxl-5">
        <div class="swiper" data-swiper-options='{
          "slidesPerView": 1,
          "spaceBetween": 24,
          "pagination": {
            "el": ".swiper-pagination",
            "clickable": true
          },
          "breakpoints": {
            "400": {
              "slidesPerView": 2,
              "spaceBetween": 24
            },
            "700": {
              "slidesPerView": 3,
              "spaceBetween": 30
            },
            "991": {
              "slidesPerView": 3,
              "spaceBetween": 40
            }
          }
        }'>
          <div class="swiper-wrapper">

            <!-- Item-->
            <div class="swiper-slide text-center text-sm-start">
              <div class="text-primary mb-3 mb-sm-4">
                <svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg">
                  <path d="M37.7794 10.6909L20.2794 1.94092C20.1926 1.89757 20.097 1.875 20 1.875C19.903 1.875 19.8074 1.89757 19.7206 1.94092L2.22063 10.6909C2.11674 10.7428 2.02936 10.8227 1.96832 10.9215C1.90727 11.0203 1.87496 11.1341 1.87501 11.2503V28.7503C1.87437 28.867 1.90641 28.9815 1.96749 29.0809C2.02857 29.1803 2.11626 29.2606 2.22063 29.3128L19.7206 38.0628C19.8074 38.1061 19.903 38.1287 20 38.1287C20.097 38.1287 20.1926 38.1061 20.2794 38.0628L37.7794 29.3128C37.8838 29.2606 37.9714 29.1803 38.0325 29.0809C38.0936 28.9815 38.1256 28.867 38.125 28.7503V11.2503C38.1251 11.1341 38.0928 11.0203 38.0317 10.9215C37.9706 10.8227 37.8833 10.7428 37.7794 10.6909ZM20 19.3015L15.1144 16.8584L30.7306 8.56279L36.1056 11.2503L20 19.3015ZM10.1144 14.3584L25.7306 6.06279L29.3556 7.87529L13.7413 16.1722L10.1144 14.3584ZM9.37501 15.3865L13.125 17.2615V22.2415L11.6919 20.8084C11.5747 20.6912 11.4158 20.6253 11.25 20.6253H9.37501V15.3865ZM20 3.19904L24.3575 5.37529L8.74126 13.6722L3.89751 11.2503L20 3.19904ZM3.12501 12.2615L8.12501 14.7615V21.2503C8.12501 21.416 8.19086 21.575 8.30807 21.6922C8.42528 21.8094 8.58425 21.8753 8.75001 21.8753H10.9913L13.3081 24.1922C13.3955 24.2795 13.5069 24.339 13.6281 24.3632C13.7493 24.3873 13.875 24.3749 13.9892 24.3276C14.1034 24.2803 14.201 24.2002 14.2696 24.0974C14.3383 23.9947 14.375 23.8739 14.375 23.7503V17.8865L19.375 20.3865V36.489L3.12501 28.364V12.2615ZM20.625 36.489V20.3865L36.875 12.2615V28.364L20.625 36.489Z" fill="currentColor"></path>
                </svg>
              </div>
              <h3 class="h5 mb-2 mb-sm-3">Free Online delivery</h3>
              <p class="fs-sm mb-0">Enjoy free and immediate delivery on all orders!</p>
            </div>

            <!-- Item -->
            <div class="swiper-slide text-center text-sm-start">
              <div class="text-primary mb-3 mb-sm-4">
                <svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg">
                  <path d="M33.6825 13.683C33.6825 6.12609 27.5564 0 19.9995 0C12.4426 0 6.31646 6.12609 6.31646 13.683C4.36283 13.9263 2.51562 15.2033 2.51562 18.168V25.3136C2.51562 28.6583 4.85694 29.8746 7.07663 29.8746H9.28111C9.70091 29.8746 10.0413 29.5342 10.0413 29.1144V14.3976C10.0413 13.9778 9.70091 13.6374 9.28111 13.6374H7.83679C7.83679 6.92018 13.2823 1.47472 19.9995 1.47472C26.7167 1.47472 32.1621 6.92018 32.1621 13.6374H30.7178C30.298 13.6374 29.9577 13.9778 29.9577 14.3976V29.0916C29.9577 29.5114 30.298 29.8518 30.7178 29.8518H32.1621C31.9493 35.0741 29.4407 36.298 24.4312 36.5184V36.0091C24.4312 35.1694 23.7506 34.4888 22.9109 34.4888H18.1295C17.2898 34.4888 16.6091 35.1694 16.6091 36.0091V38.4797C16.6091 39.3194 17.2898 40 18.1295 40H22.9261C23.7658 40 24.4464 39.3194 24.4464 38.4797V38.0388C29.2659 37.8183 33.4316 36.8225 33.6825 29.8062C35.6361 29.5629 37.4833 28.2858 37.4833 25.3212V18.1756C37.4833 15.1957 35.6437 13.9263 33.6825 13.683ZM8.52094 15.1045V28.3314H7.03862C5.91357 28.3314 3.99795 27.9361 3.99795 25.2908V18.1452C3.99795 15.5226 5.89077 15.1045 7.03862 15.1045H8.52094ZM22.9261 37.3318V38.4873H18.1295V36.0167H22.9261V37.3318ZM35.963 25.3136C35.963 27.9361 34.0702 28.3542 32.9223 28.3542H31.478V15.1577H32.9603C34.0854 15.1577 36.001 15.553 36.001 18.1984L35.963 25.3136Z" fill="currentColor"></path>
                </svg>
              </div>
              <h3 class="h5 mb-2 mb-sm-3">12/6 customer support</h3>
              <p class="fs-sm mb-0">Available 12 hours a day, 6 days a week to assist you!</p>
            </div>

            <!-- Item -->
            <div class="swiper-slide text-center text-sm-start">
              <div class="text-primary mb-3 mb-sm-4">
                <svg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg">
                  <path d="M35.1422 8.0989L20.1085 0.0881401C19.8855 -0.0308936 19.6182 -0.0292231 19.3968 0.0923166L4.77905 8.10308C4.53931 8.23464 4.39062 8.48607 4.39062 8.75964V19.2237C4.3994 27.8255 9.49571 35.6074 17.377 39.0535L19.406 39.9377C19.5956 40.0204 19.8115 40.0208 20.0016 39.9385L22.2879 38.9512C30.3153 35.5798 35.5378 27.7228 35.5386 19.0162V8.75964C35.5386 8.48315 35.3862 8.22879 35.1422 8.0989ZM34.0417 19.0162C34.04 27.1226 29.1764 34.4371 21.7019 37.5742L21.6969 37.5767L19.7059 38.4362L17.9759 37.6815C10.6397 34.4738 5.89546 27.2307 5.88711 19.2237V9.20278L19.7614 1.59882L34.0417 9.20821V19.0162Z" fill="currentColor"></path>
                  <path d="M14.2398 18.7389C13.9713 18.4244 13.4989 18.3873 13.1844 18.6558C12.8699 18.924 12.8327 19.3967 13.1013 19.7108L17.0549 24.3406C17.3188 24.6497 17.7812 24.6919 18.0961 24.4354L27.3039 16.9442C27.6247 16.6836 27.6731 16.2121 27.4121 15.8913C27.1514 15.571 26.6799 15.5221 26.3591 15.7831L17.7185 22.8124L14.2398 18.7389Z" fill="currentColor"></path>
                </svg>
              </div>
              <h3 class="h5 mb-2 mb-sm-3">Secure Online Payment</h3>
              <p class="fs-sm mb-0">Safe transactions with SSL encryption</p>
            </div>
          </div>

          <!-- Pagination (Bullets) -->
          <div class="swiper-pagination position-relative bottom-0 pt-1 mt-4 d-lg-none"></div>
        </div>
      </section>
	  
	  <!-- About US -->
      <section class="container pb-5 mb-md-3 mb-lg-4 mb-xxl-5 pt-5 mt-lg-3 mt-xl-4 mt-xxl-5">
        <div class="row pb-md-4 pb-xl-6">
          <div class="col-md-4 col-xl-4 mb-2 mb-md-0">
            <div class="card border-0 h-100 bg-size-cover bg-position-center" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/services/v1/01.jpg);">
              <div class="d-none d-sm-block d-md-none" style="height: 450px;"></div>
              <div class="d-sm-none" style="height: 350px;"></div>
            </div>
          </div>
          <div class="col-md-8 col-xl-8 position-relative">
			<div class="d-none d-xxl-block position-absolute" style="width: 861px; height: 719px; top: 50px; left: -260px;" data-aos="zoom-in" data-aos-duration="700" data-aos-offset="400">
              <svg class="text-primary opacity-10" width="861" height="719" viewBox="0 0 861 719" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                <path d="M25.1985 361.161C26.6142 363.592 28.4042 365.854 30.3902 367.846L115.89 453.613C117.366 455.093 119.008 456.457 120.69 457.697C220.882 531.542 166.267 694.09 321.314 716.256C481 739.09 730.799 588.084 806.496 453.151C844.188 385.962 885.87 273.92 840.453 199.651C808.854 147.97 742.627 142.437 686.285 142.442C616.832 142.453 556.116 167.459 491.294 135.468C449.5 114.831 426.769 82.5406 392.702 51.7928C206.459 -116.148 -88.0611 166.69 25.1985 361.161Z"></path>
              </svg>
            </div>
            <div class="pt-4 pb-sm-4 ps-md-4 ps-xl-0">
              <h2 class="h1 pb-2 pb-sm-3 pb-xl-4">എൻ്റെ സൃഷ്ടിയിലേക്ക് സ്വാഗതം</h2>
              <div class="d-flex pb-3 mb-2 mb-xl-3">
                <div class="ps-3">
                  <p class="mb-0">''ആദിയിൽ ദൈവം ആകാശവും ഭൂമിയും സൃഷ്ടിച്ചു. " തുടർന്നുള്ള ആറു ദിവസങ്ങൾ ദൈവത്തിന് സൃഷ്ടിപ്പിന്റെ ദിനങ്ങൾ ആയിരുന്നു ; വെള്ളവും മീനും മരവും മാനും അങ്ങനെ ചെറുതും വലുതുമായത്. ചുരുക്കിപ്പറഞ്ഞാൽ അമീബ തൊട്ട് അങ്ങ് ആകാശം വരെയുള്ളത് എല്ലാം. ആറാം ദിവസം മനുഷ്യനും ! ആനയ്ക്കും ഉറുമ്പിനും ദൈവം ഒരേ ജീവശ്വാസമൂതി; പക്ഷേ മനുഷ്യന്റെ പരിഗണന എപ്പോഴും വലിയ സൃഷ്ടികളിലേക്ക് മാത്രമായി ചുരുങ്ങി. വരിക്കപ്ലാവിന്റെ കൊമ്പിലൂടെ വരിവരിയായ് നടന്നു നീങ്ങുന്ന ഉറുമ്പുകളേക്കാൾ ആകാശത്തിലൂടെ കൂട്ടമായി....</p>
                </div>
              </div>
			  <button type="button" class="btn btn-primary w-100">ഞങ്ങളെക്കുറിച്ച് കൂടുതൽ അറിയുക</button>
            </div>
          </div>
        </div>
      </section>
	   
	  <!-- Popular Post -->
      <section class="container pt-5 mt-lg-3 mt-xl-4 mt-xxl-5">
        <div class="py-2 py-sm-3 py-md-4 my-md-2 my-xxl-3">
          <h2 class="h1 text-center pt-xxl-1">ജനപ്രീയ സൃഷ്ടികൾ</h2>
          <p class="fs-lg text-center pb-3 mb-lg-4">ഏറ്റവും ജനപ്രിയമായ പോസ്റ്റുകൾ എല്ലാ ദിവസവും അപ്‌ഡേറ്റ് ചെയ്യപ്പെടുന്നു.</p>
			
		  <div class="row mb-5">
				<?php
				mysqli_set_charset ($conn,'utf8'); 
				$ppq = "SELECT * FROM `popularpost`";
				$ppr = mysqli_query($conn, $ppq);
				while($pprow = mysqli_fetch_assoc($ppr))
				{
					$ppid 		= $pprow['ppid'];
					$pppostid 	= $pprow['pppostid'];
				
					mysqli_set_charset ($conn,'utf8'); 
					$grq = "SELECT * FROM `posts` WHERE `post_id` = '{$pppostid}'";
					$grr = mysqli_query($conn, $grq);
					while($gr = mysqli_fetch_assoc($grr))
					{
						$post_id 			= $gr['post_id'];
						$post_heading 		= substr($gr['post_heading'],0,135);
						$post_image 		= $gr['post_image'];
						$post_catcontent 	= strip_tags(substr($gr['post_catcontent'],0,250));
						$post_date 			= $gr['post_date'];
						$newdate			= date_create("$post_date");
						$post_category 		= $gr['post_category'];
						$post_author 		= $gr['post_author'];
						$post_userid  		= $gr['post_userid'];
					}
					
					mysqli_set_charset ($conn,'utf8'); 
					$catq = "SELECT * FROM `category` WHERE cat_itemeng = '{$post_category}'";
					$catr = mysqli_query($conn, $catq);
					while($catrow = mysqli_fetch_assoc($catr))
					{
						$catidnew 		= $catrow['cat_id'];
						$catnamenew 	= $catrow['cat_itemeng'];
					}
					
					mysqli_set_charset ($conn,'utf8');
					$uq = "SELECT * FROM user WHERE id='$post_userid'";
					$urun = mysqli_query($conn, $uq);
					while($urow=mysqli_fetch_assoc($urun)){
					$id 				= $urow['id'];
					$name 				= $urow['name'];
					$profileimg 		= $urow['profileimg'];
					$usercontent 		= substr($urow['usercontent'],0,1100);
					}
					?>
				
				<!-- Post -->
				<div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4 mb-3">
					<div class="card border-0 bg-secondary card-hover card-lifted">
					  <a href="item.php?id=<?php echo $post_id; ?>">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
							class="card-img-top d-block d-md-none"
							alt="<?php echo $post_heading; ?> XS SM" loading="lazy" 
							style="width:538px; height:316px; overflow:hidden">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
							class="card-img-top d-none d-md-block d-lg-none"
							alt="<?php echo $post_heading; ?> MD" loading="lazy" 
							style="width:436px; height:415px; overflow:hidden">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
							class="card-img-top d-none d-lg-block d-xl-none"
							alt="<?php echo $post_heading; ?> LG" loading="lazy" 
							style="width:436px; height:261px; overflow:hidden">
							
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
							class="card-img-top d-none d-xl-block d-xxl-none"
							alt="<?php echo $post_heading; ?> XL" loading="lazy" 
							style="width:416px; height:415px; overflow:hidden">	
							
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
							class="card-img-top d-none d-xxl-block"
							alt="<?php echo $post_heading; ?> xxl" loading="lazy" 
							style="width:416px; height:415px; overflow:hidden">		
					  </a>
					  <div class="card-body pb-4">
						<div class="d-flex align-items-center mb-4 mt-n1">
						  <span class="fs-sm text-body-secondary"><?php echo date_format($newdate,"d M Y"); ?></span>
						  <span class="fs-xs opacity-20 mx-3">|</span>
						  <a class="badge text-nav fs-xs border" href="category.php?catid=<?php echo $catidnew; ?>"><?php echo $post_category; ?></a>
						</div>
						<h6 class="card-title">
						  <a href="item.php?id=<?php echo $post_id; ?>"><?php echo $post_heading; ?></a>
						</h6>
						<p class="card-text" style="max-height:96px; min-height:96px; overflow:hidden"><?php echo $post_catcontent; ?></p>
					  </div>
					  <div class="card-footer pt-3">
						<a class="d-flex align-items-center text-decoration-none pb-2" href="autherprofile.php?auther=<?php echo $id; ?>">
						  <img 
						  src="<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&webp=1" width="48" height="48"
						  srcset="
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&w=576&webp=1 576w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&w=768&webp=1 768w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&w=992&webp=1 992w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&w=1200&webp=1 1200w
						  "
						  sizes="(max-width: 575px) 100px, 
								 (max-width: 767px) 540px, 
								 (max-width: 991px) 720px, 
								 (max-width: 1199px) 960px, 
								 1140px"
						  class="rounded-circle"
						  alt="<?php echo $post_author; ?>" loading="lazy" style="width:48;  height:48px">
						  <h6 class="ps-3 mb-0" style="overflow:hidden"><?php echo $post_author; ?> </h6>
						</a>
					  </div>
					</div>
				</div>
				<?php } ?>
				<!-- Post -->
		  </div>
		  <div class="col-12 order-3 text-center mb-5 mt-5">
            <button class="btn btn-primary w-md-auto w-100" type="button">കൂടുതൽ പോസ്റ്റ് ലോഡ് ചെയ്യുക</button>
          </div>	
		</div>
	  </section>	
	  
	  <!-- Ebook -->
      <section class="position-relative py-5">
        <div class="binded-content position-absolute top-0 start-0 w-100">
          <div class="binded-item position-absolute top-0 start-0 w-100 h-100 bg-size-cover bg-position-center active" id="bg-1" style="background: linear-gradient(270deg, rgba(0,0,0,0.5) 0%, rgba(0,0,0,0) 100%), url(<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/bg01.jpg&webp=1);"></div>
          <div class="binded-item position-absolute top-0 start-0 w-100 h-100 bg-size-cover bg-position-center" id="bg-2" style="background-image: linear-gradient(90deg, rgba(0,0,0,0.5) -0.47%, rgba(0,0,0,0) 100%), url(<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/bg02.jpg&webp=1);"></div>
        </div>
        <div class="container py-2 py-sm-4 py-lg-5 my-md-3 my-lg-0 my-xl-3 my-xxl-4">
          <div class="row align-items-center my-xxl-2">
            <div class="col-md-6 position-relative z-2 mb-5 mb-md-0">
              <div style="max-width: 580px;">

                <!-- Swiper controls (Prev/next buttons) -->
                <div class="d-flex pb-2 mb-3 mb-md-4 mb-xl-5">
                  <button class="btn btn-icon btn-sm btn-outline-light rounded-circle me-3" type="button" id="prev-collection" aria-label="Prev">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left-short" viewBox="0 0 16 16">
						  <path fill-rule="evenodd" d="M12 8a.5.5 0 0 1-.5.5H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5a.5.5 0 0 1 .5.5"/>
						</svg>
                  </button>
                  <button class="btn btn-icon btn-sm btn-outline-light rounded-circle" type="button" id="next-collection" aria-label="Next">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right-short" viewBox="0 0 16 16">
						  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8"/>
						</svg>
                  </button>
                </div>

                <!-- Swiper slider -->
                <div class="swiper" data-swiper-options='{
                  "spaceBetween": 40,
                  "loop": true,
                  "bindedContent": true,
                  "controlledSlider": "#cards",
                  "navigation": {
                    "prevEl": "#prev-collection",
                    "nextEl": "#next-collection"
                  }
                }'>
                  <div class="swiper-wrapper">
                    <div class="swiper-slide" data-swiper-binded="#bg-1">
                      <h2 class="display-5 text-white text-uppercase pb-2 mb-md-4 mb-xl-5">Meet the guests with a stunning set for a dinner party</h2>
                      <a class="btn btn-outline-light" href="shop-catalog.html">Explore all sets</a>
                    </div>
                    <div class="swiper-slide" data-swiper-binded="#bg-2">
                      <h2 class="display-5 text-white text-uppercase pb-2 mb-md-4 mb-xl-5">Decor for the living room or bedrooms in wood style</h2>
                      <a class="btn btn-outline-light" href="shop-catalog.html">Explore all sets</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-5 col-xl-4 offset-lg-1 offset-xl-2">
              <div class="ps-md-4 ps-lg-0">
                <div class="card border-0 rounded-1" style="max-width: 450px;">
                  <div class="card-body">

                    <!-- Controlled swiper slider -->
                    <div class="swiper" id="cards" data-swiper-options='{
                      "allowTouchMove": false,
                      "spaceBetween": 40,
                      "loop": true
                    }'>
                      <div class="swiper-wrapper">
                        <div class="swiper-slide">
                          <a class="d-block pb-3 mb-lg-5" href="shop-single.html">
							<img 
						  src="<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1" width="353" height="345"
						  srcset="<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&w=576&webp=1 576w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 768w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 992w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 1200w
						  "
						  sizes="(max-width: 575px) 100px, 
								 (max-width: 767px) 540px, 
								 (max-width: 991px) 720px, 
								 (max-width: 1199px) 960px, 
								 1140px"
						  class="rounded mx-auto d-block"
						  alt="Responsive image" loading="lazy">
					  </a>
                            
                          <div class="d-flex mb-1">
                            <h3 class="h6 mb-0">
                              <a href="shop-single.html">Set for a dinner party of 7 items</a>
                            </h3>
                          </div>
                          <div class="d-flex align-items-center">
                            <span class="me-2">$116.00</span>
                            <div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
                              <a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cart-plus" viewBox="0 0 16 16">
								  <path d="M9 5.5a.5.5 0 0 0-1 0V7H6.5a.5.5 0 0 0 0 1H8v1.5a.5.5 0 0 0 1 0V8h1.5a.5.5 0 0 0 0-1H9z"/>
								  <path d="M.5 1a.5.5 0 0 0 0 1h1.11l.401 1.607 1.498 7.985A.5.5 0 0 0 4 12h1a2 2 0 1 0 0 4 2 2 0 0 0 0-4h7a2 2 0 1 0 0 4 2 2 0 0 0 0-4h1a.5.5 0 0 0 .491-.408l1.5-8A.5.5 0 0 0 14.5 3H2.89l-.405-1.621A.5.5 0 0 0 2 1zm3.915 10L3.102 4h10.796l-1.313 7zM6 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0m7 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
								</svg>
                              </a>
                            </div>
                          </div>
                        </div>
                        <div class="swiper-slide">
                          <a class="d-block pb-3 mb-2 mb-lg-3" href="shop-single.html">
                            <img 
						  src="<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1" width="353" height="345"
						  srcset="
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&w=576&webp=1 576w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 768w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 992w,
							<?php echo $cdn; ?>/img.php?src=assets/img/landing/shop-1/collections/th02.png&webp=1 1200w
						  "
						  sizes="(max-width: 575px) 100px, 
								 (max-width: 767px) 540px, 
								 (max-width: 991px) 720px, 
								 (max-width: 1199px) 960px, 
								 1140px"
						  class="rounded mx-auto d-block"
						  alt="Responsive image" loading="lazy">
                          </a>
                          <div class="d-flex mb-1">
                            <h3 class="h6 mb-0">
                              <a href="shop-single.html">A set of flowerpots for the living room</a>
                            </h3>
                          </div>
                          <div class="d-flex align-items-center">
                            <span class="me-2">$78.00</span>
                            <div class="nav ms-auto" data-bs-toggle="tooltip" data-bs-template='<div class="tooltip fs-xs" role="tooltip"><div class="tooltip-inner bg-light text-body-secondary p-0"></div></div>' data-bs-placement="left" title="Add to cart">
                              <a class="nav-link fs-lg py-2 px-1" href="#" aria-label="Add to Cart">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cart-plus" viewBox="0 0 16 16">
								  <path d="M9 5.5a.5.5 0 0 0-1 0V7H6.5a.5.5 0 0 0 0 1H8v1.5a.5.5 0 0 0 1 0V8h1.5a.5.5 0 0 0 0-1H9z"/>
								  <path d="M.5 1a.5.5 0 0 0 0 1h1.11l.401 1.607 1.498 7.985A.5.5 0 0 0 4 12h1a2 2 0 1 0 0 4 2 2 0 0 0 0-4h7a2 2 0 1 0 0 4 2 2 0 0 0 0-4h1a.5.5 0 0 0 .491-.408l1.5-8A.5.5 0 0 0 14.5 3H2.89l-.405-1.621A.5.5 0 0 0 2 1zm3.915 10L3.102 4h10.796l-1.313 7zM6 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0m7 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
								</svg>
                              </a>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
	  
	  <!-- Latest Post -->
      <section class="container pt-5 mt-lg-3 mt-xl-4 mt-xxl-5">
        <div class="py-2 py-sm-3 py-md-4 my-md-2 my-xxl-3">
          <h2 class="h1 text-center pt-xxl-1">ഏറ്റവും പുതിയ സൃഷ്ടികൾ</h2>
          <p class="fs-lg text-center pb-3 mb-lg-4">ഞങ്ങളുടെ ഏറ്റവും പുതിയ എല്ലാ പോസ്റ്റുകളും വായിക്കുക</p>
			
		  <div class="row mb-5">
				<?php
					mysqli_set_charset ($conn,'utf8'); 
					$grq2 = "SELECT * FROM posts ORDER BY post_id DESC LIMIT 0,9";
					$grr2 = mysqli_query($conn, $grq2);
					while($gr2 = mysqli_fetch_assoc($grr2))
					{
						$post_id2 			= $gr2['post_id'];
						$post_heading2 		= substr($gr2['post_heading'],0,100);
						$post_image2 		= $gr2['post_image'];
						$post_catcontent2 	= strip_tags(substr($gr2['post_catcontent'],0,250));
						$post_date2 		= $gr2['post_date'];
						$newdate2			= date_create("$post_date2");
						$post_category2 	= $gr2['post_category'];
						$post_author2 		= $gr2['post_author'];
						$post_userid2 		= $gr2['post_userid'];
					
					mysqli_set_charset ($conn,'utf8'); 
					$catq2 = "SELECT * FROM `category` WHERE cat_itemeng = '{$post_category2}'";
					$catr2 = mysqli_query($conn, $catq2);
					while($catrow2 = mysqli_fetch_assoc($catr2))
					{
						$catidnew2 		= $catrow2['cat_id'];
						$catnamenew2 	= $catrow2['cat_itemeng'];
					}
					
					mysqli_set_charset ($conn,'utf8');
					$uq2 = "SELECT * FROM user WHERE id='$post_userid2'";
					$urun2 = mysqli_query($conn, $uq2);
					while($urow2=mysqli_fetch_assoc($urun2)){
					$id2 				= $urow2['id'];
					$name2 				= $urow2['name'];
					$profileimg2 		= $urow2['profileimg'];
					$usercontent2 		= substr($urow2['usercontent'],0,1100);
					}
				?>	
				
				<!-- Post -->
				<div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4 mb-3">
					<div class="card border-0 bg-secondary card-hover card-lifted">
					  <a href="item.php?id=<?php echo $post_id2; ?>">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image2; ?>&webp=1"
							class="card-img-top d-block d-md-none"
							alt="<?php echo $post_heading2; ?> XS SM" loading="lazy" 
							style="width:538px; height:316px; overflow:hidden">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image2; ?>&webp=1"
							class="card-img-top d-none d-md-block d-lg-none"
							alt="<?php echo $post_heading2; ?> MD" loading="lazy" 
							style="width:436px; height:415px; overflow:hidden">
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image2; ?>&webp=1"
							class="card-img-top d-none d-lg-block d-xl-none"
							alt="<?php echo $post_heading2; ?> LG" loading="lazy" 
							style="width:436px; height:261px; overflow:hidden">
							
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image2; ?>&webp=1"
							class="card-img-top d-none d-xl-block d-xxl-none"
							alt="<?php echo $post_heading2; ?> XL" loading="lazy" 
							style="width:416px; height:415px; overflow:hidden">	
							
						<img 
							src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image2; ?>&webp=1"
							class="card-img-top d-none d-xxl-block"
							alt="<?php echo $post_heading2; ?> xxl" loading="lazy" 
							style="width:416px; height:415px; overflow:hidden">
					  </a>
					  <div class="card-body pb-4">
						<div class="d-flex align-items-center mb-4 mt-n1">
						  <span class="fs-sm text-body-secondary"><?php echo date_format($newdate2,"d-M-Y"); ?>     </span>
						  <span class="fs-xs opacity-20 mx-3">|</span>
						  <a class="badge text-nav fs-xs border" href="category.php?catid=<?php echo $catidnew2; ?>"><?php echo $post_category2; ?></a>
						</div>
						<h6 class="card-title">
						  <a href="item.php?id=<?php echo $post_id2; ?>"><?php echo $post_heading2; ?></a>
						</h6>
						<p class="card-text" style="max-height:96px; min-height:96px;"><?php echo $post_catcontent2; ?></p>
					  </div>
					  <div class="card-footer pt-3">
						<a class="d-flex align-items-center text-decoration-none pb-2" href="autherprofile.php?auther=<?php echo $id2; ?>">
						  <img 
						  src="<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg2; ?>&webp=1" width="48" height="48"
						  srcset="
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg2; ?>&w=576&webp=1 576w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg2; ?>&w=768&webp=1 768w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg2; ?>&w=992&webp=1 992w,
							<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg2; ?>&w=1200&webp=1 1200w
						  "
						  sizes="(max-width: 575px) 100px, 
								 (max-width: 767px) 540px, 
								 (max-width: 991px) 720px, 
								 (max-width: 1199px) 960px, 
								 1140px"
						  class="rounded-circle"
						  alt="<?php echo $post_author2; ?>" loading="lazy" style="width:48;  height:48px">
						  <h6 class="ps-3 mb-0"><?php echo $post_author2; ?>   </h6>
						</a>
					  </div>
					</div>
				</div>
				<?php } ?>
			</div>
			<div class="col-12 order-3 text-center mb-5 mt-5">
				<button class="btn btn-primary w-md-auto w-100" type="button">കൂടുതൽ പോസ്റ്റ് ലോഡ് ചെയ്യുക</button>
			</div>	
		</div>
	  </section>
	  
	  <!-- Testimonials (Slider) -->
      <section class="container">
        <div class="card border-0 bg-primary bg-opacity-10 position-relative overflow-hidden">
          <svg class="d-block position-absolute top-0 start-0 text-white text-dark-mode-dark" width="125" height="99" viewBox="0 0 125 99" fill="none" stroke="currentColor" stroke-width="2" stroke-miterlimit="10" xmlns="http://www.w3.org/2000/svg">
            <path d="M-17.819-8.269c-.305.249-.567.498-.814.791-1.018 1.172-1.585 2.695-2.08 4.204-4.145 12.479-9.482 29.206-10.223 42.652-.553 10.063 2.516 19.232 8.885 27.317 9.729 12.347 18.367 9.096 32.037 9.887 16.084.937 25.391 8.173 39.497 16.156 13.103 7.426 27.427 6.943 39.163-1.128 13.859-9.521 26.045-30.056 30.495-46.387 4.494-16.493 8.071-34.611.247-51.865-12.273-27.053-55.726-15.233-74.457-11.996-8.827 1.523-17.131 5.829-26.176 6.708-5.73.556-11.547-.527-17.349-.059-5.25.425-14.935.234-19.225 3.72z"></path>
            <path d="M-3.201 8.561c-.582.923-1.003 1.992-1.28 3.105-2.414 9.594-4.974 20.77-4.552 29.792.175 3.589.945 7.016 2.458 10.282 1.323 2.871 3.127 5.595 5.395 8.188 7.329 8.378 13.801 6.459 23.631 7.162 11.721.849 18.862 5.727 29.143 10.795 9.467 4.658 19.705 3.882 28.285-2.402 10.049-7.323 18.571-22.058 21.581-33.937 3.054-12.054 5.104-25.134-.742-37.438-9.074-19.188-39.54-11.981-53.836-9.828-7.199 1.084-14.979 4.409-22.468 5.463-2.429.337-4.683.483-6.588.469-2.516.234-5.002.601-7.358 1.435C6.499 3.054-.074 4.474-2.692 7.829c-.204.234-.349.483-.509.732z"></path>
            <path d="M12.237 24.598c-.189.63-.407 1.304-.48 2.007-.625 6.781-.509 12.23 1.12 16.932.625 1.787 1.44 3.545 2.763 5.288 1.134 1.494 2.487 2.944 4.043 4.35 4.915 4.423 9.249 3.823 15.226 4.423 7.344.747 12.303 3.296 18.803 5.419 5.831 1.904 11.983.806 17.393-3.662C77.329 54.2 82.186 45.28 83.771 37.854c1.6-7.617 2.109-15.658-1.745-23.025-5.904-11.293-23.355-8.774-33.229-7.66-5.555.63-12.826 3.047-18.774 4.233-2.283.454-4.203.791-5.41.894a14.19 14.19 0 0 0-5.148 2.973c-2.69 2.432-6.151 5.39-7.082 8.656-.058.234-.087.469-.146.674z"></path>
            <path d="M31.449 24.407c-3.548 2.915-5.337 11.454-3.766 16.243 2.021 6.166 4.77 4.409 10.194 5.258 9.962 1.567 16.666 6.796 24.475-2.666 8.725-10.56 1.251-23.538-11.605-23.142-5.831.176-17.756 3.676-19.298 4.306z"></path>
          </svg>
          <svg class="d-block position-absolute bottom-0 end-0 text-info opacity-20" width="140" height="86" viewBox="0 0 140 86" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
            <path d="M1.56155 84.728C3.89813 95.3168 8.77193 105.696 14.3618 114.354C31.1345 140.282 61.2598 159.203 93.1024 149.868C115.683 143.25 136.909 120.078 146.906 99.6379C157.262 78.4816 157.784 62.3169 149.314 40.7686C138.656 13.647 114.088 -10.3284 84.9291 4.90565C72.6616 11.3094 61.6112 19.2912 48.9043 25.2334C37.333 30.6501 22.7611 33.4689 12.9718 42.2129C0.148055 53.665 -1.80519 69.4006 1.56155 84.728Z"></path>
          </svg>
          <svg class="d-block position-absolute text-danger opacity-20" width="100" height="109" viewBox="0 0 100 109" fill="currentColor" xmlns="http://www.w3.org/2000/svg" style="right: 60px; bottom: 62px;">
            <path d="M13.0417 15.1485C18.7381 10.3806 25.7233 6.78779 32.3773 4.42805C52.3217 -2.62478 76.5803 -0.291377 89.9528 18.0914C99.436 31.1261 101.262 52.5761 98.137 67.8474C94.9071 83.6571 88.4295 92.6458 74.8221 100.795C57.6962 111.053 34.339 113.786 24.8896 93.3249C20.9119 84.7197 18.2546 75.7674 13.8455 67.2289C9.83276 59.4504 3.10546 51.8265 1.45115 42.988C-0.716922 31.4112 4.80452 22.0566 13.0417 15.1485Z"></path>
          </svg>
          <div class="card-body position-relative z-2 px-lg-0 py-lg-5">
            <div class="row py-2 py-sm-1 py-md-3 py-lg-4 py-xl-5">
              <div class="col-md-4 col-lg-3 offset-lg-1 mb-3 mb-md-0">

                <!-- Binded items -->
                <div class="binded-content">

                  <?php
					mysqli_set_charset ($conn,'utf8'); 
					$test_q = "SELECT * FROM testimonials where status=1 order by 1 DESC LIMIT 0,10";
					$test_r = mysqli_query($conn, $test_q);
					while($test_run = mysqli_fetch_assoc($test_r)){
					$testid = $test_run['id'];
					$test_userid = $test_run['userid'];
					$test_content = $test_run['content'];
					$test_status = $test_run['status'];
					
					mysqli_set_charset ($conn,'utf8'); 
					$tu = "select * from user where id='$test_userid'";
					$tur = mysqli_query($conn, $tu);
					while($teu = mysqli_fetch_assoc($tur)){
					$id = $teu['id'];
					$name = $teu['name'];
					$profileimg = $teu['profileimg'];
					}
				  ?>
				  <!-- Item -->
                  <div class="binded-item" id="author<?php echo $testid; ?>"> 
                    <img class="d-block rounded-circle mb-3" src="<?php echo $cdn; ?>/uploads/profileimages/<?php echo $profileimg; ?>" width="86" height='86' alt="Lilianna Bocouse" loading="lazy">
                    <h6 class="mb-0"><?php echo $name; ?></h6>
                  </div>
				  <?php } ?>
                </div>
              </div>
              <div class="col-md-8 col-lg-7">

                <!-- Swiper slider -->
                <div class="swiper" data-swiper-options='{
                  "spaceBetween": 40,
                  "loop": true,
                  "autoHeight": true,
                  "bindedContent": true,
                  "pagination": {
                    "el": "#testimonials-bullets",
                    "clickable": true
                  }
                }'>
                  <div class="swiper-wrapper">
					<?php
					mysqli_set_charset ($conn,'utf8'); 
					$test_q1 = "SELECT * FROM testimonials where status=1 order by 1 DESC LIMIT 0,10";
					$test_r1 = mysqli_query($conn, $test_q1);
					while($test_run1 = mysqli_fetch_assoc($test_r1)){
					$testid1 = $test_run1['id'];
					$test_userid1 = $test_run1['userid'];
					$test_content1 = $test_run1['content'];
					$test_status1 = $test_run1['status'];
					?>
                    <!-- Item -->
                    <div class="swiper-slide" data-swiper-binded="#author<?php echo $testid1; ?>">
                      <p class="text-dark lead mb-0">“<?php echo $test_content1; ?>”</p>
                    </div>
					<?php } ?>
                    
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Swiper pagination (bullets) -->
        <div class="swiper-pagination position-relative bottom-0 pt-4 mt-2 mt-md-3" id="testimonials-bullets"></div>
      </section>
	  
	  <!-- App Download -->
      <section class="container pt-5 mt-lg-3 mt-xl-4 mt-xxl-5">
        <div class="bg-primary rounded-5 overflow-hidden mt-2 mt-sm-4 mt-lg-5">
          <img class="position-absolute top-50 start-0 translate-middle-y d-none d-md-block" src="<?php echo $cdn; ?>/uploads/assets/img/landing/yoga-studio/cta/bg.svg" width="186" alt="Background flower">
          <div class="row position-relative z-2 align-items-center">
            <div class="col-md-8 col-lg-5 offset-lg-1">
              <div class="text-center text-md-start py-5 px-4 px-sm-5 pe-md-0 ps-lg-4 ps-xl-5">
                <div class="d-flex align-items-center justify-content-center justify-content-md-start mb-2">
                  <span class="bg-white opacity-70 me-2 d-none d-md-block" style="width: 40px; height: 1px; margin-top: -1px;"></span>
                  
                </div>
                <h6 class="h2 text-white pb-2 pb-sm-3">Download entesrishti app from the Google Play Store.</h6>
                
              </div>
            </div>
            <div class="col-md-4 offset-lg-2">
				<a href="https://play.google.com/store/apps/details?id=com.apps.entesrishti&hl=en">
					<img class="mx-auto d-block mx-md-0 mt-n4 mt-md-0 border border-light-subtle rounded 2 p-3 bg-black" src="<?php echo $cdn; ?>/uploads/assets/img/market/googleplay-light.svg" width="250" height="95"  alt="Google Play Store">
				</a>
			</div>
		  </div>
		</div>
      </section>
	  
	  <!-- Subscription -->
      <section class="container pt-5 mt-lg-3 mt-xl-4 mt-xxl-5 mb-2 mb-md-3 mb-xl-4 pb-2">
		  <div class="position-relative bg-dark rounded-5 overflow-hidden p-md-5 p-4">
			<div class="position-absolute top-0 start-0 w-100 h-100" style="background-color: rgba(255, 255, 255, .03);"></div>
			<div class="position-absolute top-0 end-0 pe-5 z-2">
				<svg class="me-5" width="514" height="254" viewBox="0 0 514 254" fill="white" fill-opacity=".03" xmlns="http://www.w3.org/2000/svg">
				  <ellipse cx="257" cy="0.5" rx="257" ry="253.5"></ellipse>
				</svg>
			</div>
			<div class="d-none d-lg-flex position-absolute start-0 bottom-0 ms-n4">
				<div data-aos="fade-left" data-aos-duration="700" data-aos-anchor-placement="bottom-bottom">  
				  <svg class="text-primary" width="117" height="117" viewBox="0 0 117 117" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
					<circle cx="58.5" cy="58.5" r="58.5"></circle>
				  </svg>
				</div>
				<div data-aos="fade-right" data-aos-duration="700" data-aos-anchor-placement="bottom-bottom">
				  <svg class="text-warning" width="117" height="117" viewBox="0 0 117 117" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
					<path d="M-2.51516e-06 58.5C-3.52666e-06 70.0702 3.43096 81.3806 9.85902 91.0008C16.2871 100.621 25.4235 108.119 36.113 112.547C46.8025 116.975 58.5649 118.133 69.9128 115.876C81.2607 113.619 91.6844 108.047 99.8657 99.8657C108.047 91.6844 113.619 81.2607 115.876 69.9128C118.133 58.5649 116.975 46.8025 112.547 36.113C108.119 25.4235 100.621 16.2871 91.0009 9.85903C81.3806 3.43096 70.0702 -4.24071e-06 58.5 -5.11423e-06L58.5 58.5L-2.51516e-06 58.5Z"></path>
				  </svg>
				</div>
			</div>
			<div class="position-relative p-xl-5 p-md-4 py-4 px-sm-3 pt-5">
			  <div class="row gy-md-5 gy-4 gx-xl-5">
				<div class="col-lg-7">
				  <div class="row gy-lg-4 gy-3 gx-xl-4 gx-sm-3 gx-2">
					<h6 class="h6 pb-md-4 pb-3 text-white">നിങ്ങൾ ഒരു ആരാധകനായതിനാൽ, എന്റെ ഏറ്റവും പുതിയ സൃഷ്ടികളുമായി ബന്ധം നിലനിർത്തുകയും എപ്പോൾ വേണമെങ്കിലും നിങ്ങളുടെ പ്രിയപ്പെട്ട ഉള്ളടക്കം ആസ്വദിക്കുകയും ചെയ്യുക. ഏറ്റവും പുതിയ അപ്‌ഡേറ്റുകളും പ്രധാനപ്പെട്ട വാർത്തകളും അറിയാൻ സബ്‌സ്‌ക്രൈബുചെയ്യുക!</h6>
				  </div>
				</div>
				<div class="col-lg-5">
				  <div class="input-group rounded-pill">
					<input class="form-control" type="text" placeholder="Your email">
					<button class="btn btn-primary rounded-pill" type="button">Subscribe</button>
				  </div>
				  <div class="form-text mt-3 fs-sm">* Yes, I agree to the <a href="#">Terms & Conditions</a> and <a href="#">Privacy policy</a></div>
				</div>
			  </div>
			</div>
		  </div>
	   </section>

	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>