<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="Home";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Hero section -->
      <section class="position-relative bg-dark pt-lg-4 pt-xl-5">
        <div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
          <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
        </div>
        <div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
          <div class="row justify-content-center pt-5">
            <div class="col-lg-9 col-xl-8 text-center pt-5 mt-1">
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">Privacy Policy</h1>
			  <p class="text-white opacity-70 fs-xl">Effective Date: May 1, 2025</p>
            </div>
          </div>
        </div>
        <div class="d-none d-lg-block" style="height: 480px;"></div>
        <div class="d-lg-none" style="height: 400px;"></div>
        <div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
          <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
            <svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
          </div>
        </div>
      </section>
	  
	  <!-- Project showcase -->
      <section class="container pt-lg-1 pt-xl-1 pt-xxl-1">
        <div class="row py-sm-3 py-md-4 py-lg-5">

          <!-- Sticky sidebar with brief -->
          <aside class="col-md-3 col-lg-3 d-none d-md-block d-lg-block" style="margin-top: -125px;">
            <div class="d-flex d-md-block flex-wrap position-sticky top-0" style="padding-top: 130px;">
              <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
               <h2 class="fs-base fw-normal text-body-secondary mb-5"></h2>
			   <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1">1. Information We Collect</li>
                  <li class="d-block py-1">2. How We Use Your Information</li>
                  <li class="d-block py-1">3. Sharing of Information</li>
                  <li class="d-block py-1">4. Cookies and Tracking Technologies</li>
                  <li class="d-block py-1">5. Data Security</li>
                  <li class="d-block py-1">6. Third-Party Links</li>
                  <li class="d-block py-1">7. Your Rights</li>
                  <li class="d-block py-1">8. Children’s Privacy</li>
                  <li class="d-block py-1">9. Updates to This Policy</li>
                  <li class="d-block py-1">10. Contact Us</li>
                </ul>
              </div>
			  <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
                <h2 class="fs-base fw-normal text-body-secondary mb-2">Use Full Links</h2>
                <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1"><a href="">Terms & Conditions</a></li>
                  <li class="d-block py-1"><a href="">Refund policy</a></li>
                  <li class="d-block py-1"><a href="">Cookies Policy</a></li>
                </ul>
              </div>
            </div>
          </aside>
		  
		  <!-- Description -->
          <div class="col-md-9 mb-5">
            <div class="ps-md-4 ps-lg-0">
				<p class="fs-lg">Welcome to <strong>entesrishti.com</strong>, operated by [Your Company Name, if registered]. We value your privacy and are committed to protecting your personal information. This Privacy Policy outlines how we collect, use, disclose, and safeguard your information when you visit our website.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">1. Information We Collect</h2>
				<h5>a. Personal Information</h5>
				<ul>
				  <li class="fs-lg">Name</li>
				  <li class="fs-lg">Email address</li>
				  <li class="fs-lg">Phone number</li>
				  <li class="fs-lg">Other contact details (if voluntarily submitted)</li>
				</ul>

				<h5>b. Non-Personal Information</h5>
				<ul>
				  <li class="fs-lg">IP address</li>
				  <li class="fs-lg">Browser type and version</li>
				  <li class="fs-lg">Device information</li>
				  <li class="fs-lg">Pages visited, time spent, referring site</li>
				</ul>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">2. How We Use Your Information</h2>
				<ul>
				  <li class="fs-lg">Respond to inquiries or service requests</li>
				  <li class="fs-lg">Improve website performance and content</li>
				  <li class="fs-lg">Send updates, newsletters, or promotional content (if opted in)</li>
				  <li class="fs-lg">Ensure website security and detect fraudulent activity</li>
				</ul>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">3. Sharing of Information</h2>
				<p class="fs-lg">We <strong>do not sell or rent</strong> your personal information. However, we may share data with:</p>
				<ul>
				  <li class="fs-lg">Service providers who help us operate the website (e.g., hosting, analytics)</li>
				  <li class="fs-lg">Legal authorities when required to comply with applicable laws</li>
				</ul>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">4. Cookies and Tracking Technologies</h2>
				<p class="fs-lg">We use cookies to enhance your browsing experience by:</p>
				<ul>
				  <li class="fs-lg">Understanding user behavior on our site</li>
				  <li class="fs-lg">Personalizing content</li>
				  <li class="fs-lg">Maintaining session state</li>
				</ul>
				<p class="fs-lg">You can disable cookies via your browser settings, but some features may not function properly.</p>
				<p class="fs-lg">for detailed Cookies Policy please refer <a href="cookie-policy.php">Cookies Policy</a></p>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">5. Data Security</h2>
				<p class="fs-lg">We use appropriate security measures to protect your personal information from unauthorized access, disclosure, or alteration.</p>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">6. Third-Party Links</h2>
				<p class="fs-lg">Our site may contain links to third-party websites. We are not responsible for the privacy practices or content of those sites.</p>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">7. Your Rights</h2>
				<p class="fs-lg">You may have the right to:</p>
				<ul>
				  <li class="fs-lg">Access or update your personal information</li>
				  <li class="fs-lg">Request deletion of your data</li>
				  <li class="fs-lg">Withdraw consent at any time</li>
				  <li class="fs-lg">File a complaint with a data protection authority</li>
				</ul>
				<p class="fs-lg">Contact us at <strong>info@entesrishti.com / support@entesrishti.com</strong> to exercise these rights.</p>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">8. Children’s Privacy</h2>
				<p class="fs-lg">We do not knowingly collect information from children under the age of 13. If we do, we will delete it promptly upon discovery.</p>
				<h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">10. Contact Us</h2>
				<p class="fs-lg">If you have any questions about this policy, contact us at:</p>
				<ul>
					<li class="fs-lg"><strong>Email:</strong> info@entesrishti.com / support@entesrishti.com</li>
					<li class="fs-lg"><strong>Phone/WhatsApp:</strong> +91 9567288591</li>
					<li class="fs-lg"><strong>Website:</strong> <a href="https://entesrishti.com">https://entesrishti.com</a></li>
				</ul>
            </div>
          </div>
        </div>
	  </section>
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>