<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="Home";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  <!-- Hero section -->
      <section class="position-relative bg-dark pt-lg-4 pt-xl-5">
        <div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
          <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
        </div>
        <div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
          <div class="row justify-content-center pt-5">
            <div class="col-lg-9 col-xl-8 text-center pt-5 mt-1">
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">Cancellation & Refund Policy</h1>
			  <p class="text-white opacity-70 fs-xl">Effective Date: May 1, 2025</p>
            </div>
          </div>
        </div>
        <div class="d-none d-lg-block" style="height: 480px;"></div>
        <div class="d-lg-none" style="height: 400px;"></div>
        <div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
          <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
            <svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
          </div>
        </div>
      </section>
	  
	  <!-- Project showcase -->
      <section class="container pt-lg-1 pt-xl-1 pt-xxl-1">
        <div class="row py-sm-3 py-md-4 py-lg-5">

          <!-- Sticky sidebar with brief -->
          <aside class="col-md-3 col-lg-3 d-none d-md-block d-lg-block" style="margin-top: -125px;">
            <div class="d-flex d-md-block flex-wrap position-sticky top-0" style="padding-top: 130px;">
              <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
               <h2 class="fs-base fw-normal text-body-secondary mb-5"></h2>
			   <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1">1. Cancellation Policy</li>
                  <li class="d-block py-1">2. Refund Policy</li>
                  <li class="d-block py-1">3. Processing Time</li>
                  <li class="d-block py-1">4. Contact Us</li>
                </ul>
              </div>
			  <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
                <h2 class="fs-base fw-normal text-body-secondary mb-2">Use Full Links</h2>
                <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1"><a href="">Terms & Conditions</a></li>
                  <li class="d-block py-1"><a href="">Cookies Policy</a></li>
                  <li class="d-block py-1"><a href="">Privacy Policy</a></li>
                </ul>
              </div>
            </div>
          </aside>
		  
		  <!-- Description -->
          <div class="col-md-9 mb-5">
            <div class="ps-md-4 ps-lg-0">
              <h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">1. Cancellation Policy</h2>
              <p class="fs-lg">Users may request cancellation of a service or subscription by contacting our support team at <strong>support@entesrishti.com</strong> within 24 hours of placing the order.</p>
              <p class="fs-lg">Requests made after this window may not be eligible for cancellation depending on the status of the service.</p>
              <h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">2. Refund Policy</h2>
              <p class="fs-lg">Refunds are processed under the following conditions:</p>
			  <ul>
				  <li class="fs-lg">If a service is not delivered as described</li>
				  <li class="fs-lg">If a technical error or billing issue has occurred</li>
				  <li class="fs-lg">If we are unable to fulfill your request or deliver the product/service</li>
			  </ul>
			  <p class="fs-lg">Refunds are not applicable to services that have already been consumed or delivered in full.</p>
              <h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">3. Processing Time</h2>
			  <p class="fs-lg">Approved refunds will be processed within 7–10 business days via the original payment method.</p>
			  <h2 class="h1 pt-3 pt-sm-4 pt-xl-5 pb-2">4. Contact Us</h2>
			  <p class="fs-lg">For cancellations or refund-related queries, contact us at:</p>
			  <ul>
				  <li class="fs-lg"><strong>Email:</strong> info@entesrishti.com / support@entesrishti.com</li>
				  <li class="fs-lg"><strong>Phone/WhatsApp:</strong> +91 9567288591</li>
			  </ul>
            </div>
          </div>
        </div>
	  </section>	
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>