<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="Home";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  
	  <!-- Hero section -->
      <section class="position-relative bg-dark pt-lg-4 pt-xl-5">
        <div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
          <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
        </div>
        <div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
          <div class="row justify-content-center pt-5">
            <div class="col-lg-9 col-xl-8 text-center pt-5 mt-1">
              <h1 class="display-4 text-white pt-3 mt-3 mb-4">Terms & Conditions</h1>
			  <p class="text-white opacity-70 fs-xl">Effective Date: May 1, 2025</p>
            </div>
          </div>
        </div>
        <div class="d-none d-lg-block" style="height: 480px;"></div>
        <div class="d-lg-none" style="height: 400px;"></div>
        <div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
          <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
            <svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
          </div>
        </div>
      </section>
	  
	  <!-- Project showcase -->
      <section class="container pt-lg-1 pt-xl-1 pt-xxl-1">
        <div class="row py-sm-3 py-md-4 py-lg-5">

          <!-- Sticky sidebar with brief -->
          <aside class="col-md-3 col-lg-3 d-none d-md-block d-lg-block" style="margin-top: -125px;">
            <div class="d-flex d-md-block flex-wrap position-sticky top-0" style="padding-top: 130px;">
              <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
               <h2 class="fs-base fw-normal text-body-secondary mb-5"></h2>
			   <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1">1. Use of the Website</li>
                  <li class="d-block py-1">2. Membership & Content Submission</li>
                  <li class="d-block py-1">3. Community Guidelines</li>
                  <li class="d-block py-1">4. Intellectual Property</li>
                  <li class="d-block py-1">5. Comments and User Interactions</li>
                  <li class="d-block py-1">6. Data Collection & Cookies</li>
                  <li class="d-block py-1">7. Third-Party Links</li>
                  <li class="d-block py-1">8. Termination of Access</li>
                  <li class="d-block py-1">9. Modifications to Terms</li>
                  <li class="d-block py-1">10. Dispute Resolution</li>
                  <li class="d-block py-1">11. Disclaimer of Liability</li>
                  <li class="d-block py-1">12. Contact Us</li>
                </ul>
              </div>
			  <div class="pb-3 mb-2 mb-lg-4 me-5 me-md-0">
                <h2 class="fs-base fw-normal text-body-secondary mb-2">Use Full Links</h2>
                <ul class="list-unstyled fs-lg fw-semibold text-dark mb-0">
                  <li class="d-block py-1"><a href="">Privacy Policy</a></li>
                  <li class="d-block py-1"><a href="">Refund policy</a></li>
                  <li class="d-block py-1"><a href="">Cookies Policy</a></li>
                </ul>
              </div>
            </div>
          </aside>
		  
		  <!-- Description -->
          <div class="col-md-9 mb-5">
            <div class="ps-md-4 ps-lg-0">
				<p class="fs-lg">Welcome to <strong>Entesrishti.com</strong>. By accessing and using this website, Facebook group, or any affiliated platforms under Entesrishti, you agree to comply with and be bound by the following Terms and Conditions. If you do not agree to these terms, please refrain from using our services.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">1. Use of the Website</h2>
				<p class="fs-lg">Entesrishti is a platform that enables members to publish their own original creative works such as poems, short stories, articles, artwork, and photography. By using this website, you confirm that you are at least 18 years of age or have parental consent.</p>
				<ul>
				  <li class="fs-lg">You may not use this platform for any illegal or unauthorized purpose.</li>
				  <li class="fs-lg">You must not attempt to gain unauthorized access to the website, its databases, or its members' information.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">2. Membership & Content Submission</h2>
				<ul>
				  <li class="fs-lg">Only registered members and Facebook group participants are allowed to submit content.</li>
				  <li class="fs-lg">All submissions must be original and owned by the member. Submitting copied or plagiarized content is strictly prohibited.</li>
				  <li class="fs-lg">The Entesrishti Admin Team reserves the right to edit, publish, reject, or remove any submission at its discretion.</li>
				  <li class="fs-lg">By submitting content, you grant Entesrishti a non-exclusive, royalty-free, worldwide license to publish, display, and share your content across all its platforms.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">3. Community Guidelines</h2>
				<ul>
				  <li class="fs-lg">All posts must be respectful, non-offensive, and non-discriminatory.</li>
				  <li class="fs-lg">Do not post material that is defamatory, inflammatory, obscene, hateful, or promotes violence.</li>
				  <li class="fs-lg">Do not make derogatory comments toward other members or post personal attacks, especially against female members.</li>
				  <li class="fs-lg">The Admin Panel reserves the right to delete inappropriate content and block users violating these guidelines without notice.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">4. Intellectual Property</h2>
				<ul>
				  <li class="fs-lg">Unless otherwise stated, Entesrishti and/or its licensors own the intellectual property rights for all material on this website.</li>
				  <li class="fs-lg">You must not reproduce, sell, rent, or redistribute any material from this website without express permission.</li>
				  <li class="fs-lg">Members are responsible for ensuring that the content they submit does not violate copyright laws.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">5. Comments and User Interactions</h2>
				<ul>
				  <li class="fs-lg">Entesrishti allows users to post comments on content. These comments do not reflect the views of the platform.</li>
				  <li class="fs-lg">We reserve the right to remove comments that are inappropriate, spammy, or abusive.</li>
				  <li class="fs-lg">You are solely responsible for the content of your comments.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">6. Data Collection & Cookies</h2>
				<p class="fs-lg">We use cookies to enhance user experience and collect basic usage data. By using our website, you consent to the use of cookies as outlined in our <a href="/cookie-policy.html">Cookie Policy</a>.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">7. Third-Party Links</h2>
				<p class="fs-lg">Our platform may contain links to third-party websites. These links are provided for convenience only, and we are not responsible for the content or privacy practices of these websites.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">8. Termination of Access</h2>
				<p class="fs-lg">Entesrishti reserves the right to terminate or suspend access to any user account or content at any time for violations of these terms, without prior notice.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">9. Modifications to Terms</h2>
				<p class="fs-lg">We may revise these Terms & Conditions from time to time. Updated versions will be posted on this page with the new effective date. Continued use of the platform constitutes acceptance of the updated terms.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">10. Dispute Resolution</h2>
				<p class="fs-lg">Any disputes related to member submissions or content will be handled by the Entesrishti Admin Panel. The panel's decision will be final and binding.</p>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">11. Disclaimer of Liability</h2>
				<ul>
				  <li class="fs-lg">Entesrishti is not liable for any loss or damages resulting from content posted by members.</li>
				  <li class="fs-lg">We do not guarantee that the website will be error-free or uninterrupted.</li>
				  <li class="fs-lg">All services are provided "as is" without warranty of any kind.</li>
				</ul>
				<h2 class="h1 pt-2 pt-sm-3 pt-md-4 pt-lg-5 pb-2">12. Contact Us</h2>
				<p class="fs-lg">If you have any questions about these Terms and Conditions, feel free to contact us at:</p>
				<ul>
					<li class="fs-lg"><strong>Email:</strong> info@entesrishti.com / support@entesrishti.com</li>
					<li class="fs-lg"><strong>Phone/WhatsApp:</strong> +91 9567288591</li>
					<li class="fs-lg"><strong>Website:</strong> <a href="https://entesrishti.com">https://entesrishti.com</a></li>
				</ul>
			</div>	
		</section>  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>