<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="Home";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
	  
	  <!-- Testimonials -->
      <section class="pt-5 mt-5 mt-sm-2 mt-xl-4 mt-xxl-5 mb-5">
        <div class="container pt-5 pt-md-4 pt-lg-5 mt-xl-2 mt-xxl-3 mb-5">
          <div class="fs-sm text-uppercase mb-3">Testimonials</div>
          <h2 class="display-6 pb-3 mb-lg-4">ഞങ്ങളുടെ ഉപഭോക്താക്കൾ എന്താണ് പറയുന്നത്</h2>
          <div class="card border-0 bg-secondary overflow-hidden">
            <div class="card-body position-relative z-2 px-lg-0 py-lg-5">
				<div class="row py-2 py-sm-1 py-md-3 py-lg-4 py-xl-5">
					<div class="col-md-4 col-lg-3 offset-lg-1 mb-3 mb-md-0">
						<!-- Binded items -->
						<div class="binded-content">
							<?php
							mysqli_set_charset ($conn,'utf8'); 
							$test_q = "SELECT * FROM testimonials where status=1 order by 1 DESC LIMIT 0,10";
							$test_r = mysqli_query($conn, $test_q);
							while($test_run = mysqli_fetch_assoc($test_r)){
							$testid = $test_run['id'];
							$test_userid = $test_run['userid'];
							$test_content = $test_run['content'];
							$test_status = $test_run['status'];
							
							mysqli_set_charset ($conn,'utf8'); 
							$tu = "select * from user where id='$test_userid'";
							$tur = mysqli_query($conn, $tu);
							while($teu = mysqli_fetch_assoc($tur)){
							$id = $teu['id'];
							$name = $teu['name'];
							$profileimg = $teu['profileimg'];
							}
							?>
							<!-- Item -->
							<div class="binded-item" id="author<?php echo $testid; ?>"> 
								<img class="d-block rounded-circle mb-3" src="<?php echo $cdn; ?>/uploads/profileimages/<?php echo $profileimg; ?>" width="86" height='86' alt="Lilianna Bocouse" loading="lazy">
								<h6 class="mb-0"><?php echo $name; ?></h6>
							</div>
							<?php } ?>
						</div>
					</div>
					<div class="col-md-8 col-lg-7">
						<!-- Swiper slider -->
						<div class="swiper" data-swiper-options='{
						  "spaceBetween": 40,
						  "loop": true,
						  "autoHeight": true,
						  "bindedContent": true,
						  "pagination": {
							"el": "#testimonials-bullets",
							"clickable": true
						  }
						}'>
							<div class="swiper-wrapper">
								<?php
								mysqli_set_charset ($conn,'utf8'); 
								$test_q1 = "SELECT * FROM testimonials where status=1 order by 1 DESC LIMIT 0,10";
								$test_r1 = mysqli_query($conn, $test_q1);
								while($test_run1 = mysqli_fetch_assoc($test_r1)){
								$testid1 = $test_run1['id'];
								$test_userid1 = $test_run1['userid'];
								$test_content1 = $test_run1['content'];
								$test_status1 = $test_run1['status'];
								?>
								<!-- Item -->
								<div class="swiper-slide" data-swiper-binded="#author<?php echo $testid1; ?>">
								  <p class="text-dark lead mb-0">“<?php echo $test_content1; ?>”</p>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
          </div>

          <!-- Swiper pagination (bullets) -->
          <div class="swiper-pagination position-relative bottom-0 pt-4 mt-2 mt-md-3" id="testimonials-bullets"></div>
        </div>
      </section>
	  
	  
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>