<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/session.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch logged-in user data
$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

?>
<?php $pagename="DRAFT"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper bg-secondary">
		<header class="navbar navbar-expand-lg fixed-top bg-light p-1">
			<?php include('../config/header.php')?>
		</header>
		<div class="container py-5 mt-4 mt-lg-5 mb-lg-4 my-xl-5">
			<div class="row pt-sm-2 pt-lg-0">
				<!-- Sidebar (offcanvas on sreens < 992px) -->
				<?php include('config/usernav.php')?>
				  
				<!-- Page content -->
				<div class="col-lg-9 pt-4 pb-2 pb-sm-4">
					<h1 class="h2 mb-4">Draft</h1>
					 
						<!-- Basic info -->
						<section class="card py-1 p-md-2 p-xl-3 p-xxl-4 mb-4">
							<div class="card-body">
								<div class="row">
								<?php
									mysqli_set_charset ($conn,'utf8');
									$q2= "SELECT * FROM draft WHERE post_userid='$user_id'";
									$r2 = mysqli_query($conn, $q2);
									while($row=mysqli_fetch_assoc($r2)){
										$draft_id = $row['draft_id'];
										$post_userid = $row['post_userid'];
										$post_author = $row['post_author'];
										$post_heading = $row['post_heading'];
										$post_date = $row['post_date'];
										$post_category = $row['post_category'];
										$post_catcontent = strip_tags (substr($row['post_catcontent'],0,200));
										$post_image = $row['post_image'];
										$post_content = $row['post_content'];
										$post_draft_id = '';
								?>
								
								
								<!-- Post -->
								<div class="col-12 col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
									<div class="card border-0 bg-secondary card-hover card-lifted">
										<img 
											src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
											class="card-img-top d-block d-md-none"
											alt="<?php echo $post_heading; ?> XS SM" loading="lazy" 
											style="width:538px; height:316px; overflow:hidden">
										<img 
											src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
											class="card-img-top d-none d-md-block d-lg-none"
											alt="<?php echo $post_heading; ?> MD" loading="lazy" 
											style="width:436px; height:415px; overflow:hidden">
										<img 
											src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
											class="card-img-top d-none d-lg-block d-xl-none"
											alt="<?php echo $post_heading; ?> LG" loading="lazy" 
											style="width:436px; height:261px; overflow:hidden">
											
										<img 
											src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
											class="card-img-top d-none d-xl-block d-xxl-none"
											alt="<?php echo $post_heading; ?> XL" loading="lazy" 
											style="width:416px; height:415px; overflow:hidden">	
											
										<img 
											src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1"
											class="card-img-top d-none d-xxl-block"
											alt="<?php echo $post_heading; ?> xxl" loading="lazy" 
											style="width:416px; height:415px; overflow:hidden">		
									  <div class="card-body pb-4">
										<h6 class="card-title">
										  <a href="#"><?php echo $draft_id; ?>. <?php echo $post_heading; ?></a>
										</h6>
										<p class="card-text" style="max-height:96px; min-height:96px; overflow:hidden"><?php echo $post_catcontent; ?></p>
									  </div>
									  <div class="card-footer pt-3 d-flex justify-content-between">
										<?php
											$ddq2= "SELECT * FROM posts WHERE post_draft_id ='$draft_id'";
											$ddr2 = mysqli_query($conn, $ddq2);
											while($ddrow=mysqli_fetch_assoc($ddr2)){
											$post_draft_id = $ddrow['post_draft_id'];
											}
										?>
										<?php
										if ($draft_id == "$post_draft_id") { ?>
											<a disabled type="button" class="btn btn-primary">POSTED | പോസ്റ്റുചെയ്ത</a>
											<a href="useraction.php?delDraft=<?php echo $draft_id; ?>" type="button" class="btn btn-danger" onclick="return confirm('You were going to remove this draft post forever? നിങ്ങൾ ഈ ഡ്രാഫ്റ്റ് പോസ്റ്റ് ശാശ്വതമായി നീക്കം ചെയ്യാൻ പോവുകയാണോ?');">Delete</a>
										<?php } else { ?>
											<a href="draft-edit.php?draftid=<?php echo $draft_id; ?>" type="button" class="btn btn-primary">Edit & Publish</a>
											
											<a href="useraction.php?delDraft=<?php echo $draft_id; ?>" type="button" class="btn btn-danger" onclick="return confirm('Do you really want to delete this draft post? നിങ്ങൾക്ക് ഈ ഡ്രാഫ്റ്റ് പോസ്റ്റ് ഇല്ലാതാക്കണോ?');">Delete</a>
										<?php }
										?>
									  </div>
									</div>
								</div>
								<?php } ?>
								<!-- Post -->
								</div>
							</div>
						</section>	
				</div>
			</div>
        </div>
		<!-- Sidebar toggle button -->
        <button class="d-lg-none btn btn-sm fs-sm btn-primary w-100 rounded-0 fixed-bottom" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAccount">
			<i class="ai-menu me-2"></i>
			Account menu
		</button>
    </main>
	<!-- Footer -->
    <?php include('../config/footer.php')?>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
  </body>
</html>