<?php
function email_exists($email, $conn) {
    $stmt = $conn->prepare("SELECT id FROM user WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();
    return $stmt->num_rows > 0;
}

function calculate_age($dob) {
    $dobObject = new DateTime($dob);
    $today = new DateTime();
    $age = $today->diff($dobObject)->y;
    return $age;
}

function check_password_strength($password) {
    return strlen($password) >= 8 &&
           preg_match('/[A-Z]/', $password) &&
           preg_match('/[a-z]/', $password) &&
           preg_match('/[0-9]/', $password) &&
           preg_match('/[^a-zA-Z0-9]/', $password);
}

function log_activity($user_id, $email, $message) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $time = date('Y-m-d H:i:s');
    $log = "$time | User: $email | IP: $ip | UA: $ua | $message\n";
    file_put_contents(__DIR__ . '/../logs/activity.log', $log, FILE_APPEND);
}

function notify_admin($name, $email, $mobile) {
    $admin_email = 'forgetpassword@entesrishti.com';
    $subject = "New User Registration - $name";
    $message = "<p>New user registered:</p><ul>
        <li>Name: $name</li>
        <li>Email: $email</li>
        <li>Mobile: $mobile</li></ul>";
    send_email($admin_email, $subject, $message);
}
