<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit;
}
require_once '../cdn/db/db.php';
require_once 'includes/functions.php';
require_once 'includes/csrf.php';
require_once 'includes/session.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] == 'login') {
    header('Content-Type: application/json');
    ob_clean();

    $email = filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL);
    $password = $_POST['password'];
    $remember = isset($_POST['remember']);

    if (!$email || !$password) {
        echo json_encode(['status' => 'error', 'message' => 'Email and password are required.']);
        exit;
    }

    $stmt = $conn->prepare("SELECT * FROM user WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        if (!password_verify($password, $user['password'])) {
            echo json_encode(['status' => 'error', 'message' => 'Incorrect email or password.']);
            exit;
        } elseif ($user['verified'] == 0) {
            echo json_encode(['status' => 'error', 'message' => 'Email not verified.']);
            exit;
        } else {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];

            if ($remember) {
                setcookie('remember_me', session_id(), time() + (86400 * 30), "/", "", false, true);
            }

            if (empty($user['profileimg']) || empty($user['publishname']) || empty($user['sex']) || empty($user['address']) || empty($user['usercontent']) || empty($user['language'])) {
                echo json_encode(['status' => 'incomplete_profile']);
                exit;
            } else {
                echo json_encode(['status' => 'success']);
                exit;
            }
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Account not found.']);
        exit;
    }
}
$csrf_token = generate_csrf_token();
$pagename = "Login";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
	<style>
    #overlay_loader {
        display:none;
        position:fixed;
        top:0;
        left:0;
        width:100%;
        height:100%;
        background:rgba(0,0,0,0.5);
        z-index:1050;
    }
    </style>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper" style="background-image: url(https://cdn.entesrishti.com/assets/fe/svg/components/wave-pattern.svg);">
		<div class="d-flex justify-content-center position-relative h-100 pt-5">
			<!-- Home button-->
			<a class="text-nav btn btn-icon bg-light border rounded-circle position-absolute top-0 end-0 z-2 p-0 mt-3 me-3 mt-sm-4 me-sm-4" href="../index.php" data-bs-toggle="tooltip" data-bs-placement="left" title="Back to home" aria-label="Back to home">
				<i class="ai-home"></i>
			</a>
			<div class="container mt-auto">
				<div class="row align-items-center justify-content-center">
					<!-- Sign in form -->
					<div class="col-12 col-sm-12 col-md-9 col-lg-8 mb-5 mb-md-0">
					  <div class="card border-0 py-md-3 py-lg-4 px-lg-4 px-xl-5">
						<div class="card-body border border-primary rounded">
						  <h1 class="display-6 py-2 pb-lg-3 text-center">Sign in to entesrishti</h1>
						  <div id="message_area"></div>
						  <form id="loginForm" autocomplete="off" novalidate>
							<input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
							<input type="hidden" name="action" value="login">
							<div class="pb-3 mb-3">
							  <div class="position-relative">
								<i class="bi bi-envelope fs-lg position-absolute top-50 start-0 translate-middle-y ms-3"></i>
								<input class="form-control form-control-lg ps-5" type="email" name="email" placeholder="Email address" required>
							  </div>
							</div>
							<div class="mb-4">
							  <div class="position-relative">
								<i class="bi bi-lock fs-lg position-absolute top-50 start-0 translate-middle-y text-black opacity-80 ms-3"></i>
								<div class="password-toggle">
								  <input class="form-control form-control-lg ps-5" type="password" name="password" placeholder="Password" required>
								  <label class="password-toggle-btn" aria-label="Show/hide password">
									<input class="password-toggle-check" type="checkbox">
									<span class="password-toggle-indicator"></span>
								  </label>
								</div>
							  </div>
							</div>
							<div class="d-flex flex-wrap align-items-center justify-content-between pb-4">
							  <div class="form-check my-1">
								<input class="form-check-input" type="checkbox" name="remember" id="remember">
								<label class="form-check-label ms-1" for="remember">Remember Me</label>
							  </div>
							  <a class="text-primary fs-sm fw-semibold text-decoration-none my-1" href="#">Forgot password?</a>
							</div>
							<button class="btn btn-lg btn-primary w-100 mb-4" type="submit">Sign in</button>

							<!-- Sign in with social account 
							<h2 class="h6 text-center pt-3 pt-lg-4 mb-4">Or sign in with your social account</h2>
							<div class="row row-cols-1 row-cols-sm-2 gy-3 pb-2">
							  <div class="col">
								<a class="btn btn-icon btn-secondary btn-google btn-lg w-100" href="#">
								  <i class="bi bi-google fs-xl me-2"></i>
								  Google
								</a>
							  </div>
							  <div class="col">
								<a class="btn btn-icon btn-secondary btn-facebook btn-lg w-100" href="#">
								  <i class="bi bi-facebook fs-xl me-2"></i>
								  Facebook
								</a>
							  </div>
							</div>-->
						  </form>
						  <div class="mt-3">
								<p class="text-center">By clicking "Sign in", you agree to our <a href="">Terms & Conditions</a>, <a href="">Privacy & Policy</a> and <a href="">Cookies Policy</a></p>
								
								<p class="text-center mt-3">Don't have an account yet? <a href="signup.php">Sign up here</a></p>
						  </div>
						</div>
					  </div>
					</div>
				</div>	
			</div>	
		</div>
	</main>
	<!-- Footer -->
	<div class="container nav fs-sm pt-lg-5 pt-sm-2 mb-lg-5 mb-sm-3 justify-content-center">
		<span class="text-body-secondary text-center">&copy; 2017-2025 by entesrishti.com. All Rights Reserved
	</div>
	<!-- Spinner Overlay -->
<div id="overlay_loader">
  <div class="d-flex justify-content-center align-items-center" style="height:100%;">
    <div class="text-center text-white">
      <div class="spinner-border" role="status"></div>
      <div id="loader_text" class="mt-3 fs-5"></div>
    </div>
  </div>
</div>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
	<script>
$(document).ready(function() {
    $('#loginForm').on('submit', function(e) {
        e.preventDefault();
        $('#message_area').html('');
        $('#overlay_loader').show();
        $('#loader_text').text('Checking for account...');

        var formData = $(this).serialize();

        $.ajax({
            type: 'POST',
            url: '',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'incomplete_profile') {
                    setTimeout(function() {
                        $('#loader_text').text('Profile incomplete. Redirecting to profile setup...');
                    }, 1000);
                    setTimeout(function() {
                        window.location.href = 'profileing.php';
                    }, 3000);
                } else if (response.status === 'success') {
                    setTimeout(function() {
                        $('#loader_text').text('Login successful. Redirecting to dashboard...');
                    }, 1000);
                    setTimeout(function() {
                        window.location.href = 'dashboard.php';
                    }, 3000);
                } else {
                    $('#overlay_loader').hide();
                    $('#message_area').html('<div class="alert alert-danger">'+response.message+'</div>');
                }
            },
            error: function(xhr) {
                console.log(xhr.responseText);
                $('#overlay_loader').hide();
                $('#message_area').html('<div class="alert alert-danger">Unexpected error. Please try again.</div>');
            }
        });
    });
});
</script>
  </body>
</html>