<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/session.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch logged-in user data
$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

?>
<?php $pagename="MYPOSTS"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper bg-secondary">
		<header class="navbar navbar-expand-lg fixed-top bg-light p-1">
			<?php include('../config/header.php')?>
		</header>
		<div class="container py-5 mt-4 mt-lg-5 mb-lg-4 my-xl-5">
			<div class="row pt-sm-2 pt-lg-0">
				<!-- Sidebar (offcanvas on sreens < 992px) -->
				<?php include('config/usernav.php')?>
				  
				<!-- Page content -->
				<div class="col-lg-9 pt-4 pb-2 pb-sm-4">
					<h1 class="h2 mb-4">My Posts timeline | എൻ്റെ പോസ്റ്റുകളുടെ ടൈംലൈൻ</h1>
					<?php
						$ip=$_SERVER['REMOTE_ADDR'];
						$sql="SELECT * FROM posts WHERE post_userid='$user_id'";
						$result=mysqli_query($conn,$sql);
						$row=mysqli_num_rows($result);
					?> 
					<?php echo $row; ?></p>
						<!-- Basic info -->
						<section class="card py-1 p-md-2 p-xl-3 p-xxl-4 mb-4">
							<?php
							$bookq = "SELECT * FROM posts WHERE post_userid='$user_id'";
							$bookr = mysqli_query($conn, $bookq);
							if(mysqli_num_rows($bookr) > 0)
							{
							?>
							<div class="card-body">
								 <div class="ps-md-4 ps-xl-0">
								  <div class="steps steps-hoverable">
									<?php
									mysqli_set_charset ($conn,'utf8');
									$q2= "SELECT * FROM posts WHERE post_userid='$user_id' ORDER BY post_id DESC ";
									$r2 = mysqli_query($conn, $q2);
									while($row=mysqli_fetch_assoc($r2)){
										$post_id = $row['post_id'];
										$post_userid = $row['post_userid'];
										$post_author = $row['post_author'];
										$post_heading = $row['post_heading'];
										$post_date = $row['post_date'];
										$newdate = date_create("$post_date");
										$post_category = $row['post_category'];
										$post_catcontent = strip_tags (substr($row['post_catcontent'],0,800));
										$post_image = $row['post_image'];
									?>
									<div class="step py-3 py-xl-4">
									  <div class="step-number">
										<div class="step-number-inner"><?php echo $post_id; ?></div>
									  </div>
									  <div class="step-body">
										<!-- Post -->
										<div class="card border-0 bg-secondary card-hover card-lifted">
											  <a href="item.php?id=<?php echo $post_id; ?>">
												<img src="<?php echo $cdn; ?>/img.php?src=postimages/<?php echo $post_image; ?>&webp=1" class="card-img-top" alt="<?php echo $post_heading; ?>" loading="lazy">
											  </a>
											  <div class="card-body p-4">
												<div class="d-flex align-items-center mb-4 mt-n1">
												  <span class="fs-sm text-body-secondary"><?php echo date_format($newdate,"d-M-Y"); ?></span>
												  <span class="fs-xs opacity-20 mx-3">|</span>
												  <a class="badge text-nav fs-xs border" href="category.php?catid=<?php echo $catidnew; ?>"><?php echo $post_category; ?></a>
												</div>
												<h6 class="card-title">
												  <a href="item.php?id=<?php echo $post_id; ?>"><?php echo $post_heading; ?></a>
												</h6>
												<p class="card-text mb-3"><?php echo $post_catcontent; ?></p>
											  </div>
											  
										</div>
				
										
										
									  </div>
									  
									</div>
									<?php } ?>
									
								  </div>
								</div>
							
							</div>
							<?php 
				}
				else
				{
				?>
				<!-- Content -->
				<div class="content container-fluid mb-5">
						<div class="row justify-content-sm-center text-center">
						  <div class="col-sm-12 col-md-12 col-lg-12">
							<img class="img-fluid mb-5" src="<?php echo $cdn; ?>/assets/be/svg/illustrations/sorry.svg" alt="Image Description" style="max-width: 21rem;">
								<h3>ക്ഷമിക്കണം! നിങ്ങളുടെ പേരിൽ ലഭ്യമായ പ്രോജക്റ്റുകളൊന്നുമില്ല <br>Sorry! No Projects Avaliable In Your Name</h3>
						  </div>
						</div>
						<!-- End Row -->
				</div>
				<!-- End Content -->
				<?php } ?>
						</section>	
				</div>
			</div>
        </div>
		<!-- Sidebar toggle button -->
        <button class="d-lg-none btn btn-sm fs-sm btn-primary w-100 rounded-0 fixed-bottom" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAccount">
			<i class="ai-menu me-2"></i>
			Account menu
		</button>
    </main>
	<!-- Footer -->
    <?php include('../config/footer.php')?>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
  </body>
</html>