<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/csrf.php';
require_once 'includes/session.php';
mysqli_set_charset ($conn,'utf8mb4');

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch current user data
$stmt = $conn->prepare("SELECT profileimg, publishname, sex, address, usercontent, language FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!validate_csrf_token($_POST['csrf_token'])) {
        $errors[] = "Invalid CSRF token.";
    } else {
        $publishname = htmlspecialchars(trim($_POST['publishname']));
        $sex = htmlspecialchars(trim($_POST['sex']));
        $address = htmlspecialchars(trim($_POST['address']));
        $usercontent = htmlspecialchars(trim($_POST['usercontent']));
        $language = htmlspecialchars(trim($_POST['language']));
        $new_filename = $user['profileimg'];

        if (!empty($_POST['cropped_image'])) {
            $data = $_POST['cropped_image'];
            $data = str_replace('data:image/png;base64,', '', $data);
            $data = base64_decode($data);
            $new_filename = 'uploads/profile_' . $user_id . '.png';
            file_put_contents($new_filename, $data);
        }

        if (empty($errors)) {
            $stmt = $conn->prepare("UPDATE user SET profileimg = ?, publishname = ?, sex = ?, address = ?, usercontent = ?, language = ? WHERE id = ?");
            $stmt->bind_param("ssssssi", $new_filename, $publishname, $sex, $address, $usercontent, $language, $user_id);
            if ($stmt->execute()) {
                echo "<script>alert('Profile updated successfully!'); window.location.href='dashboard.php';</script>";
                exit;
            } else {
                $errors[] = "Failed to update profile. Please try again.";
            }
        }
    }
}

$csrf_token = generate_csrf_token();
?>
<?php $pagename="Home"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | Complete Your Profile</title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
	<link href="https://cdn.jsdelivr.net/npm/cropperjs@1.5.13/dist/cropper.min.css" rel="stylesheet">
	<style>
        .modal-lg { max-width: 600px; }
        #imagePreviewContainer img { max-width: 100%; }
        #croppedPreview img { max-width: 150px; border-radius: 50%; margin-top: 1rem; }
    </style>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper" style="background-image: url(https://cdn.entesrishti.com/assets/fe/svg/components/wave-pattern.svg);">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1 mb-5">
        
      </header>
	  <!-- Hero slider -->
      <section class="position-relative py-5" data-bs-theme="light">
		<div class="container mt-auto">
			<div class="row align-items-center justify-content-center">
				<div class="col-12 col-sm-12 col-md-9 col-lg-8 mb-5 mb-md-0">
					<div class="card border-0 py-md-3 py-lg-4 px-lg-4 px-xl-5">
						<div class="card-body border border-primary rounded">
							<h2 class="text-center mb-5 mt-5">Complete Your Profile</h2>
							<?php if ($errors): ?>
								<div class="alert alert-danger">
									<?php foreach ($errors as $error) echo "<p>$error</p>"; ?>
								</div>
							<?php endif; ?>
							<form method="POST" action="" enctype="multipart/form-data" autocomplete="off">
								<input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
								<input type="hidden" name="cropped_image" id="cropped_image">
								
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">Profile Image</label>
									<input type="file" class="form-control" id="profileInput" accept="image/*" required>
									<div id="croppedPreview"></div>
								</div>
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">Publish Name</label>
									<input type="text" class="form-control" name="publishname" id="publishname" value="<?php echo htmlspecialchars($user['publishname'] ?? ''); ?>" required>
									<small id="publishname_status" class="form-text"></small>
								</div>
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">Sex</label>
									<select class="form-control" name="sex" required>
										<option value="">Select</option>
										<option value="Male" <?php if(($user['sex'] ?? '') == 'Male') echo 'selected'; ?>>Male</option>
										<option value="Female" <?php if(($user['sex'] ?? '') == 'Female') echo 'selected'; ?>>Female</option>
										<option value="Other" <?php if(($user['sex'] ?? '') == 'Other') echo 'selected'; ?>>Other</option>
									</select>
								</div>
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">Address</label>
									<textarea class="form-control" name="address" required><?php echo htmlspecialchars($user['address'] ?? ''); ?></textarea>
								</div>
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">User Content (Bio)</label>
									<textarea class="form-control" name="usercontent" required><?php echo htmlspecialchars($user['usercontent'] ?? ''); ?></textarea>
								</div>
								<div class="mb-3">
									<label for="input-lg" class="form-label fs-base">Language</label>
									<select class="form-control" name="language" required>
										<option value="">Select</option>
										<option value="English" <?php if(($user['language'] ?? '') == 'English') echo 'selected'; ?>>English</option>
										<option value="Hindi" <?php if(($user['language'] ?? '') == 'Hindi') echo 'selected'; ?>>Hindi</option>
										<option value="Malayalam" <?php if(($user['language'] ?? '') == 'Malayalam') echo 'selected'; ?>>Malayalam</option>
									</select>
								</div>
								<button type="submit" class="btn btn-primary w-100">Update Profile</button>
							</form>
						</div>
						<!-- Cropper Modal -->
						<div class="modal fade" id="cropperModal" tabindex="-1" aria-labelledby="cropperModalLabel" aria-hidden="true">
						  <div class="modal-dialog modal-lg">
							<div class="modal-content">
							  <div class="modal-header">
								<h5 class="modal-title">Crop Profile Image</h5>
								<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							  </div>
							  <div class="modal-body">
								<div id="imagePreviewContainer">
								  <img class="img-fluid rounded mx-auto d-block" id="cropImage" src="#" alt="Crop preview">
								</div>
							  </div>
							  <div class="modal-footer">
								<button type="button" class="btn btn-secondary w-100 w-sm-auto mb-3 mb-sm-0" data-bs-dismiss="modal">Cancel</button>
								<button type="button" class="btn btn-primary w-100 w-sm-auto ms-sm-3" id="cropAndSave">Save</button>
							  </div>
							</div>
						  </div>
						</div>
					</div>	
				</div>
			</div>
		</div>		
		
       




	   

        
      </section>
	</main>
	<!-- Footer -->
    <?php include('../config/footer.php')?>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
	<script src="https://cdn.jsdelivr.net/npm/cropperjs@1.5.13/dist/cropper.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script>
	let cropper;
	let cropModal = new bootstrap.Modal(document.getElementById('cropperModal'));

	$('#profileInput').on('change', function (e) {
		const file = e.target.files[0];
		if (!file) return;

		const reader = new FileReader();
		reader.onload = function (e) {
			$('#cropImage').attr('src', e.target.result);
			cropModal.show();
			setTimeout(() => {
				const image = document.getElementById('cropImage');
				cropper = new Cropper(image, {
					aspectRatio: 1,
					viewMode: 1,
					autoCropArea: 1,
					scalable: false,
					zoomable: false
				});
			}, 100);
		};
		reader.readAsDataURL(file);
	});

	$('#cropAndSave').on('click', function () {
		const canvas = cropper.getCroppedCanvas({ width: 300, height: 300 });
		const croppedData = canvas.toDataURL('image/png');
		$('#cropped_image').val(croppedData);
		$('#croppedPreview').html('<img src="' + croppedData + '" alt="Preview">');
		cropModal.hide();
	});

	$('#publishname').on('keyup', function () {
		const val = $(this).val();
		if (val.length > 2) {
			$.post('check_publishname.php', { publishname: val }, function (data) {
				$('#publishname_status').html(data);
				$('#submitBtn').prop('disabled', data.includes('taken'));
			});
		}
	});
	</script>
  </body>
</html>