<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/csrf.php';
require_once 'includes/session.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch current user data
$stmt = $conn->prepare("SELECT profileimg, publishname, sex, address, usercontent, language FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!validate_csrf_token($_POST['csrf_token'])) {
        $errors[] = "Invalid CSRF token.";
    } else {
        $publishname = htmlspecialchars(trim($_POST['publishname']));
        $sex = htmlspecialchars(trim($_POST['sex']));
        $address = htmlspecialchars(trim($_POST['address']));
        $usercontent = htmlspecialchars(trim($_POST['usercontent']));
        $language = htmlspecialchars(trim($_POST['language']));
        $new_filename = $user['profileimg'];

        // Handle cropped profile image
        if (!empty($_POST['cropped_image'])) {
            $data = $_POST['cropped_image'];
            $data = str_replace('data:image/png;base64,', '', $data);
            $data = base64_decode($data);
            $new_filename = 'uploads/profile_' . $user_id . '.png';
            file_put_contents($new_filename, $data);
        }

        if (empty($errors)) {
            $stmt = $conn->prepare("UPDATE user SET profileimg = ?, publishname = ?, sex = ?, address = ?, usercontent = ?, language = ? WHERE id = ?");
            $stmt->bind_param("ssssssi", $new_filename, $publishname, $sex, $address, $usercontent, $language, $user_id);
            if ($stmt->execute()) {
                $success = "Profile updated successfully.";
                header('Location: dashboard.php');
                exit;
            } else {
                $errors[] = "Failed to update profile. Please try again.";
            }
        }
    }
}

$csrf_token = generate_csrf_token();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Complete Your Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Complete Your Profile</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $error) echo "<p>$error</p>"; ?>
        </div>
    <?php elseif ($success): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    <form method="POST" action="" enctype="multipart/form-data" autocomplete="off">
        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
        <div class="mb-3">
            <label>Profile Image</label>
            <input type="file" class="form-control" id="profileInput" accept="image/*" required>
            <div id="preview" class="mt-2"></div>
        </div>
        <div class="mb-3">
            <label>Publish Name</label>
            <input type="text" class="form-control" name="publishname" value="<?php echo htmlspecialchars($user['publishname'] ?? ''); ?>" required>
        </div>
        <div class="mb-3">
            <label>Sex</label>
            <select class="form-control" name="sex" required>
                <option value="">Select</option>
                <option value="Male" <?php if(($user['sex'] ?? '') == 'Male') echo 'selected'; ?>>Male</option>
                <option value="Female" <?php if(($user['sex'] ?? '') == 'Female') echo 'selected'; ?>>Female</option>
                <option value="Other" <?php if(($user['sex'] ?? '') == 'Other') echo 'selected'; ?>>Other</option>
            </select>
        </div>
        <div class="mb-3">
            <label>Address</label>
            <textarea class="form-control" name="address" required><?php echo htmlspecialchars($user['address'] ?? ''); ?></textarea>
        </div>
        <div class="mb-3">
            <label>User Content (Bio)</label>
            <textarea class="form-control" name="usercontent" required><?php echo htmlspecialchars($user['usercontent'] ?? ''); ?></textarea>
        </div>
        <div class="mb-3">
            <label>Language</label>
            <select class="form-control" name="language" required>
                <option value="">Select</option>
                <option value="English" <?php if(($user['language'] ?? '') == 'English') echo 'selected'; ?>>English</option>
                <option value="Hindi" <?php if(($user['language'] ?? '') == 'Hindi') echo 'selected'; ?>>Hindi</option>
                <option value="Malayalam" <?php if(($user['language'] ?? '') == 'Malayalam') echo 'selected'; ?>>Malayalam</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary w-100">Update Profile</button>
    </form>
</div>
</body>
</html>
