<?php
ob_start();
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/functions.php';
require_once 'includes/mailer.php';
require_once 'includes/csrf.php';
require_once 'includes/session.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] == 'register') {
    header('Content-Type: application/json');
    ob_clean();
    $errors = [];

    if (!validate_csrf_token($_POST['csrf_token'])) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid CSRF token.']);
        exit;
    }

    $name = htmlspecialchars(trim($_POST['name']));
    $email = filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL);
    $mobile_raw = htmlspecialchars(trim($_POST['mobile']));
    $mobile = '+91' . $mobile_raw;
    $dob = $_POST['dob'];
    $password = $_POST['password'];
    $terms = isset($_POST['terms']) ? 1 : 0;

    $age = calculate_age($dob);

    log_activity(null, $email, 'New Registration Form Submitted');

    if (!$name || !$email || !$mobile_raw || !$dob || !$password) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit;
    } elseif ($age < 13) {
        echo json_encode(['status' => 'error', 'message' => 'Age must be 13 or above.']);
        exit;
    } elseif (!preg_match('/^[0-9]{10}$/', $mobile_raw)) {
        echo json_encode(['status' => 'error', 'message' => 'Mobile number must be exactly 10 digits.']);
        exit;
    } elseif (!check_password_strength($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Password does not meet strength requirements.']);
        exit;
    } elseif (email_exists($email, $conn)) {
        echo json_encode(['status' => 'error', 'message' => 'Email already registered.']);
        exit;
    } elseif (!$terms) {
        echo json_encode(['status' => 'error', 'message' => 'You must agree to terms and conditions.']);
        exit;
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $verification_code = bin2hex(random_bytes(32));
        $stmt = $conn->prepare("INSERT INTO user (name, email, mobile, DOB, password, terms, verification_code) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssis", $name, $email, $mobile, $dob, $hash, $terms, $verification_code);
        if ($stmt->execute()) {
            log_activity($stmt->insert_id, $email, 'User Account Created');
            send_verification_email($email, $name, $verification_code);
            log_activity($stmt->insert_id, $email, 'Verification Email Sent');
            echo json_encode(['status' => 'success']);
            exit;
        } else {
            log_activity(null, $email, 'Database Error During Registration');
            echo json_encode(['status' => 'error', 'message' => 'Something went wrong. Please try again.']);
            exit;
        }
    }
}

$csrf_token = generate_csrf_token();
?>
<?php $pagename="Home"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<style>
    #overlay_loader {
        display:none;
        position:fixed;
        top:0;
        left:0;
        width:100%;
        height:100%;
        background:rgba(0,0,0,0.5);
        z-index:1050;
    }
    </style>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper" style="background-image: url(https://cdn.entesrishti.com/assets/fe/svg/components/wave-pattern.svg);">
		<div class="d-flex justify-content-center position-relative h-100 pt-5">
			<!-- Home button-->
			<a class="text-nav btn btn-icon bg-light border rounded-circle position-absolute top-0 end-0 z-2 p-0 mt-3 me-3 mt-sm-4 me-sm-4" href="../index.php" data-bs-toggle="tooltip" data-bs-placement="left" title="Back to home" aria-label="Back to home">
				<i class="ai-home"></i>
			</a>
			<div class="container mt-auto">
				<div class="row align-items-center justify-content-center">
					<!-- Sign in form -->
					<div class="col-12 col-sm-12 col-md-9 col-lg-8 mb-5 mb-md-0">
					  <div class="card border-0 py-md-3 py-lg-4 px-lg-4 px-xl-5">
						<div class="card-body border border-primary rounded">
						  <h1 class="display-6 py-2 pb-lg-3 text-center">No account? Sign up</h1>
						  <div id="message_area"></div>
						  <form id="registerForm" autocomplete="off" novalidate>
						  <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
						  <input type="hidden" name="action" value="register">
							<div class="pb-3 mb-3">
							  <div class="position-relative">
								<input class="form-control form-control-lg" type="text" name="name" placeholder="Full Name" required>
							  </div>
							</div>
							<div class="pb-3 mb-3">
							  <div class="position-relative">
								<input class="form-control form-control-lg" type="email" id="email" name="email" placeholder="Email address" required>
								<div id="email_status"></div>
							  </div>
							</div>
							<div class="pb-3 mb-3">
							  <div class="input-group p-0">
								<span class="input-group-text">+91</span>
								<input class="form-control form-control-lg" type="text" name="mobile" id="mobile" maxlength="10" pattern="\d{10}" placeholder="Mobile Number" required>
							   </div>
							   <small id="mobile_error" class="text-danger"></small>
							</div>
							<div class="pb-3 mb-3">
							  <div class="position-relative">
								<input class="form-control form-control-lg" type="date" name="dob" id="dob" placeholder="Date of Birth" required>
								<small id="dob_error" class="text-danger"></small>
							  </div>
							</div>
							<div class="mb-4">
							  <div class="position-relative">
								<div class="password-toggle">
								  <input class="form-control form-control-lg" type="password" id="password" name="password" placeholder="Password" required>
								  <label class="password-toggle-btn" aria-label="Show/hide password">
									<input class="password-toggle-check" type="checkbox">
									<span class="password-toggle-indicator"></span>
								  </label>
								</div>
								<div id="password-requirements" class="form-text">
									<ul>
										<li id="length" style="color:red;">At least 8 characters</li>
										<li id="uppercase" style="color:red;">At least 1 uppercase letter</li>
										<li id="lowercase" style="color:red;">At least 1 lowercase letter</li>
										<li id="number" style="color:red;">At least 1 number</li>
										<li id="symbol" style="color:red;">At least 1 special character</li>
									</ul>
								</div>
								
							  </div>
							</div>
							
							<div class="pb-3 mb-3">
							  <div class="position-relative">
								<input type="checkbox" class="form-check-input" name="terms" required>
								<label class="form-check-label">I agree to our <a href="">Terms & Conditions</a>, <a href="">Privacy & Policy</a> and <a href="">Cookies Policy</a></label>
							  </div>
							</div>
							
							<button class="btn btn-lg btn-primary w-100 mb-4" type="submit">Create An Account</button>
							
							<!-- Sign in with social account -->
							<h2 class="h6 text-center pt-3 pt-lg-4 mb-4">Or sign up with your social account</h2>
							<div class="row row-cols-1 row-cols-sm-2 gy-3">
								<div class="col">
								  <a class="btn btn-icon btn-outline-secondary btn-google btn-lg w-100" href="#">
									<i class="ai-google fs-xl me-2"></i>
									Google
								  </a>
								</div>
								<div class="col">
								  <a class="btn btn-icon btn-outline-secondary btn-facebook btn-lg w-100" href="#">
									<i class="ai-facebook fs-xl me-2"></i>
									Facebook
								  </a>
								</div>
							</div>
						  </form>
						  <div class="mt-3">
							<p class="text-center mt-3">Remember your password? <a href="login.php"> Log in</a></p>
						  </div>
						</div>
					  </div>
					</div>
				</div>	
			</div>	
		</div>
		<!-- Spinner Overlay -->
		<div id="overlay_loader">
		  <div class="d-flex justify-content-center align-items-center" style="height:100%;">
			<div class="text-center text-white">
			  <div class="spinner-border" role="status"></div>
			  <div id="loader_text" class="mt-3 fs-5"></div>
			</div>
		  </div>
		</div>
	</main>
	<!-- Footer -->
	<div class="container nav fs-sm pt-lg-5 pt-sm-2 mb-lg-5 mb-sm-3 justify-content-center">
		<span class="text-body-secondary text-center">&copy; 2017-2025 by entesrishti.com. All Rights Reserved
	</div>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
	<script>
$(document).ready(function() {
    $('#email').keyup(function() {
        var email = $(this).val();
        if (email.length > 5) {
            $.ajax({
                url: 'check_email.php',
                method: 'POST',
                data: { email: email },
                success: function(response) {
                    $('#email_status').html(response);
                }
            });
        }
    });

    $('#mobile').on('input', function() {
        var mobile = $(this).val().replace(/[^0-9]/g, '');
        $(this).val(mobile);
        if (mobile.length !== 10) {
            $('#mobile_error').text('Mobile number must be exactly 10 digits.');
        } else {
            $('#mobile_error').text('');
        }
    });

    $('#dob').on('change', function() {
        let dob = new Date(this.value);
        let today = new Date();
        let age = today.getFullYear() - dob.getFullYear();
        let m = today.getMonth() - dob.getMonth();
        if (m < 0 || (m === 0 && today.getDate() < dob.getDate())) {
            age--;
        }
        if (age < 13) {
            $('#dob_error').text('You must be at least 13 years old.');
        } else {
            $('#dob_error').text('');
        }
    });

    $('#password').on('keyup', function() {
        var password = $(this).val();
        $('#length').css('color', password.length >= 8 ? 'green' : 'red');
        $('#uppercase').css('color', /[A-Z]/.test(password) ? 'green' : 'red');
        $('#lowercase').css('color', /[a-z]/.test(password) ? 'green' : 'red');
        $('#number').css('color', /[0-9]/.test(password) ? 'green' : 'red');
        $('#symbol').css('color', /[^A-Za-z0-9]/.test(password) ? 'green' : 'red');
    });

    $('#registerForm').on('submit', function(e) {
        e.preventDefault();
        $('#message_area').html('');
        $('#overlay_loader').show();
        $('#loader_text').text('Verifying details...');
        var formData = $(this).serialize();

        setTimeout(function() {
            $('#loader_text').text('Creating account...');
        }, 1000);
        setTimeout(function() {
            $('#loader_text').text('Sending verification email...');
        }, 2000);
        setTimeout(function() {
            $('#loader_text').text('Finishing registration...');
        }, 3000);

        $.ajax({
            type: 'POST',
            url: '',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    setTimeout(function() {
                        window.location.href = 'welcome.php';
                    }, 4000);
                } else {
                    $('#overlay_loader').hide();
                    $('#message_area').html('<div class="alert alert-danger">'+response.message+'</div>');
                }
            },
            error: function(xhr) {
                console.log(xhr.responseText);
                $('#overlay_loader').hide();
                $('#message_area').html('<div class="alert alert-danger">Unexpected error. Please try again.</div>');
            }
        });
    });
});
</script>
  </body>
</html>