<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/session.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch logged-in user data
$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

?>
<?php $pagename="TESTIMONIALS"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper bg-secondary">
		<header class="navbar navbar-expand-lg fixed-top bg-light p-1">
			<?php include('../config/header.php')?>
		</header>
		<div class="container py-5 mt-4 mt-lg-5 mb-lg-4 my-xl-5">
			<div class="row pt-sm-2 pt-lg-0">
				<!-- Sidebar (offcanvas on sreens < 992px) -->
				<?php include('config/usernav.php')?>
				  
				<!-- Page content -->
				<div class="col-lg-9 pt-4 pb-2 pb-sm-4">
					<h1 class="h2 mb-4">എന്റെ അംഗീകാരപത്രങ്ങൾ  <br> My Testimonials</h1>
					 
						<!-- Basic info -->
						<section class="card py-1 p-md-2 p-xl-3 p-xxl-4 mb-4">
							<?php
							$bookq = "SELECT * FROM testimonials WHERE userid='$user_id'";
							$bookr = mysqli_query($conn, $bookq);
							if(mysqli_num_rows($bookr) > 0)
							{
							?>
							<div class="card-body">
								<?php
							mysqli_set_charset ($conn,'utf8');
							$tq= "SELECT * FROM testimonials WHERE userid='$user_id'";
							$tr = mysqli_query($conn, $tq);
							while($trow=mysqli_fetch_assoc($tr)){
							$id = $trow['id'];
							$userid = $trow['userid'];
							$content = $trow['content'];
							$status = $trow['status'];
							?>
								<!-- Quotation -->
								<div class="card border-0 bg-secondary">
								  <div class="card-body">
									<figure>
									  <blockquote class="blockquote">
										<p><?php echo $content; ?></p>
									  </blockquote>
									  
									</figure>
								  </div>
								</div>
							<?php } ?>
							</div>
							<?php 
				}
				else
				{
				?>
				<!-- Content -->
				<div class="content container-fluid mb-5">
						<div class="row justify-content-sm-center text-center">
						  <div class="col-sm-12 col-md-12 col-lg-12">
							<img class="img-fluid mb-5" src="<?php echo $cdn; ?>/assets/be/svg/illustrations/sorry.svg" alt="Image Description" style="max-width: 21rem;">
								<h1>ക്ഷമിക്കണം! നിങ്ങളുടെ പേരിൽ അംഗീകാരപത്രങ്ങളൊന്നുമില്ല <br>Sorry! No Testimonials Avaliable In Your Name</h1>
						  </div>
						  <button type="button" data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-primary">
							  Add New Testimonial
							  <i class="tio-chat-outlined ml-1"></i>
						  </button>
						</div>
						<!-- End Row -->
				</div>
				<!-- End Content -->
				<?php } ?>
						</section>	
				</div>
			</div>
        </div>
		<!-- Sidebar toggle button -->
        <button class="d-lg-none btn btn-sm fs-sm btn-primary w-100 rounded-0 fixed-bottom" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAccount">
			<i class="ai-menu me-2"></i>
			Account menu
		</button>
    </main>
	<!-- Footer -->
    <?php include('../config/footer.php')?>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
  </body>
</html>