<?php
session_start();
require_once '../cdn/db/db.php';
require_once 'includes/session.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch logged-in user data
$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

?>
<?php $pagename="NEWPOSTS"?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('../config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('../config/loader.php')?>
	<!-- Search modal -->
	<?php include('../config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('../config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper bg-secondary">
		<header class="navbar navbar-expand-lg fixed-top bg-light p-1">
			<?php include('../config/header.php')?>
		</header>
		<div class="container py-5 mt-4 mt-lg-5 mb-lg-4 my-xl-5">
			<div class="row pt-sm-2 pt-lg-0">
				<!-- Sidebar (offcanvas on sreens < 992px) -->
				<?php include('config/usernav.php')?>
				  
				<!-- Page content -->
				<div class="col-lg-9 pt-4 pb-2 pb-sm-4">
					<h1 class="h2 mb-4">New Writing Post</h1>
					 
						<!-- Basic info -->
						<section class="card py-1 p-md-2 p-xl-3 p-xxl-4 mb-4">
							<div class="card-body">
								<!-- Text input -->
								<div class="mb-3">
								  <label for="text-input" class="form-label">തലക്കെട്ട് | Heading</label>
								  <input class="form-control" type="text" id="text-input" value="Artisanal kale">
								</div>
								
								<!-- Select -->
								<div class="mb-3">
								  <label for="select-input" class="form-label">വിഭാഗം തിരഞ്ഞെടുക്കൂ | Select the category</label>
								  <select class="form-select" id="select-input">
									<option>Choose option...</option>
									<option>Option item 1</option>
									<option>Option item 2</option>
									<option>Option item 3</option>
								  </select>
								</div>
								
								<!-- File input -->
								<div class="mb-3">
								  <label for="file-input" class="form-label">ചിത്രം | Image</label>
								  <input class="form-control" type="file" id="file-input">
								  <small>Upload 250*250 above | .jpeg | .jpg | .png | images only</small>
								</div>
								
								<!-- Textarea -->
								<div class="mb-3">
								  <label for="textarea-input" class="form-label">ഉള്ളടക്കം | Content</label>
								  <textarea class="form-control" id="textarea-input" rows="5">ഉള്ളടക്കം | Content</textarea>
								</div>
							</div>
							<div class="card-footer">
								<a type="submit" class="btn btn-dark mx-auto" href="newpost.php">Cancel</a>
								<div class="d-grid gap-5 d-md-block float-end">
									<button type="submit" name="save" id="save" class="btn btn-info me-2"><i class="bi bi-save"></i>&nbsp;&nbsp;Save & Draft</button>
									<button type="submit" name="publish" id="publish" class="btn btn-primary float-end"><i class="bi bi-cloud-upload-fill"></i>&nbsp;&nbsp;Publish</button>
								</div>
							</div>
						</section>	
				</div>
			</div>
        </div>
		<!-- Sidebar toggle button -->
        <button class="d-lg-none btn btn-sm fs-sm btn-primary w-100 rounded-0 fixed-bottom" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAccount">
			<i class="ai-menu me-2"></i>
			Account menu
		</button>
    </main>
	<!-- Footer -->
    <?php include('../config/footer.php')?>
	<!-- Back to top button -->
    <?php include('../config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('../config/js.php')?>
	<script src="https://cdn.entesrishti.com/assets/be/vendor/tinymce/6/tinymce.min.js"></script>
	<script>
    tinymce.init({
      selector: 'textarea',
      plugins: 'paste fullscreen nonbreaking emoticons',
      toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | emoticons | fullscreen | ltr rtl',
	  menubar: 'file edit view insert format',	
   });
  </script>
  </body>
</html>