<?php 
session_start();
include('cdn/db/db.php');
if (isset($_SESSION['user_id'])) {
	$user_id = $_SESSION['user_id'];

	// Fetch logged-in user data
	$stmt = $conn->prepare("SELECT id, name, profileimg, publishname, email, mobile, sex, DOB, address, usercontent, language, role, signupdate FROM user WHERE id = ?");
	$stmt->bind_param("i", $user_id);
	$stmt->execute();
	$result = $stmt->get_result();
	$user = $result->fetch_assoc();
} else{}	
$pagename="WRITERS";
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
	<!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO meta tags -->
    <title>entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?></title>
	<meta name="title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta name="description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<!-- Open Graph / Facebook -->
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://entesrishti.com/">
	<meta property="og:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="og:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="og:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<meta property="fb:app_id" content="1449012105165035">
	<!-- Twitter -->
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://entesrishti.com/">
	<meta property="twitter:title" content="entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>">
	<meta property="twitter:description" content="A platform for reading, writing, and sharing stories in Malayalam and other languages. <?php echo $pagename; ?>">
	<meta property="twitter:image" content="<?php echo $cdn; ?>/assets/fe/svg/logos/entesrishti.png">
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org/",
	  "@type": "WebSite",
	  "name": "entesrishti | എന്റെസൃഷ്ടി | <?php echo $pagename; ?>",
	  "url": "https://entesrishti.com/index.php",
	  "potentialAction": {
		"@type": "SearchAction",
		"target": "index.php{search_term_string}",
		"query-input": "required name=search_term_string"
	  }
	}
	</script>
    <?php include('config/css.php')?>
  </head>
  <!-- Body -->
  <body>
    <!-- Page loading spinner -->
    <?php include('config/loader.php')?>
	<!-- Search modal -->
	<?php include('config/search.php')?>
    <!-- Cart offcanvas -->
    <?php include('config/cart.php')?>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <header class="navbar navbar-expand-lg fixed-top bg-light p-1">
        <?php include('config/header.php')?>
      </header>
		<!-- Hero section -->
		<section class="position-relative bg-dark pt-lg-4 pt-xl-5">
			<div class="jarallax position-absolute top-0 start-0 w-100 h-100" data-jarallax data-speed="0.4">
			  <div class="jarallax-img" style="background-image: url(<?php echo $cdn; ?>/uploads/assets/img/landing/saas-4/hero-bg-pattern.png);"></div>
			</div>
			<div class="container position-relative z-2 pt-2 pt-sm-4 pt-md-5">
			  <div class="row justify-content-center pt-5">
				<div class="col-lg-12 col-xl-12 text-center pt-5 mt-1">
				  <h1 class="h1 text-white pt-3 mt-3 mb-4">എൻ്റെ സൃഷ്ടിയിലെ എഴുത്തുകാർ</h1>
				  <h1 class="display-4 text-white pt-3 mt-3 mb-4">Our Writers</h1>
				  
				</div>
			  </div>
			</div>
			<div class="d-none d-lg-block" style="height: 480px;"></div>
			<div class="d-lg-none" style="height: 400px;"></div>
			<div class="d-flex position-absolute bottom-0 start-0 w-100 overflow-hidden mb-n1" style="color: var(--ar-body-bg);">
			  <div class="position-relative start-50 translate-middle-x flex-shrink-0" style="width: 3774px;">
				<svg width="3774" height="201" viewBox="0 0 3774 201" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 200.003C0 200.003 1137.52 0.188224 1873.5 0.000134392C2614.84 -0.189325 3774 200.003 3774 200.003H0Z" fill="currentColor"/></svg>
			  </div>
			</div>
		</section>
	  
		<!-- Page container -->
		<div class="container pb-lg-5 pb-md-4 pb-2 my-5 mb-5">
			<div class="container">
				<div class="row">
					<?php
					mysqli_set_charset ($conn,'utf8');
					$q = "SELECT * FROM user WHERE scroll=1";
					$run = mysqli_query($conn, $q);
					while($authorrow=mysqli_fetch_assoc($run)){
					$uid 			= $authorrow['id'];
					$name 			= $authorrow['name'];
					$profileimg 	= $authorrow['profileimg'];
					$usercontent 	= substr($authorrow['usercontent'],0,400);
					?>
					<!-- Author widget -->
					<div class="col col-sm-12 col-md-6 col-lg-4 col-xl-4 pb-3">
						<div class="card border-0 bg-secondary p-3">
							<div class="card-body text-center">
								<img class="d-block rounded-circle mx-auto mb-3" src="<?php echo $cdn; ?>/img.php?src=profileimages/<?php echo $profileimg; ?>&webp=1" width="80" height="80" style="max-width:80px; max-height:80px; min-width:80px; min-height:80px;"alt="Author image">
								<h3 class="h6 mb-2 pb-1"><?php echo $name; ?></h3>
								<a class="btn btn-outline-primary btn-sm mb-3" href="#">Follow</a>
								<a class="btn btn-outline-primary btn-sm mb-3" href="#">All projects</a>
							</div>
						</div>
					</div>
					<?php } ?>
				</div>
			</div>	
		</div>
	</main>
	<!-- Footer -->
    <?php include('config/footer.php')?>
	<!-- Back to top button -->
    <?php include('config/gotop.php')?>
	<!-- Vendor scripts: JS libraries and plugins -->
	<?php include('config/js.php')?>
  </body>
</html>