# SEO Master - Phase 1 (Cyber Bot Crawl Engine)

This Phase 1 bundle gives you:
- MySQL schema for **audits**, **audit_urls (queue)**, **audit_pages (parsed data)**
- A shared-hosting-friendly **batch crawler** (cron-driven)
- URL discovery (robots + sitemap + homepage internal links)
- Fetch + parse (title, meta description, canonical, robots meta, headings, image alt counts, link counts, schema blocks)
- Minimal UI to start an audit + watch progress

## 1) Install

1. Upload the `seomaster` folder to your hosting (recommended: as a subfolder like `/public_html/seomaster`)
2. Create a MySQL database and user in cPanel
3. Import SQL:
   - `sql/schema.sql`
4. Edit DB credentials:
   - `app/config/config.php`

## 2) Set Web Root

If you can use a separate document root, point it to:
- `seomaster/public`

If you cannot, you can keep `public` inside your folder and access:
- `.../seomaster/public/index.php`

## 3) Create Cron Job (Required)

Add a cron job (example every 2 minutes):

```
/usr/local/bin/php -q /home/USER/public_html/seomaster/app/cron/run-crawl-batch.php
```

Adjust path and PHP binary depending on your host.

## 4) Run

Open:
- `public/index.php`

Enter a URL and click **Start Audit**.

The crawler will:
- Discover URLs
- Crawl in batches via cron
- Store page data in DB

## 5) What’s Next (Phase 2)

Phase 2 will add:
- `audit_issues` table
- Rule engine (Pass/Warn/Fail)
- Scoring engine (0-100)
- Dashboard categories + issue drill-down

---

Security notes:
- SSRF protection blocks localhost/private IPs.
- The bot respects robots.txt by default.
