<?php
// POST: start_url (required)
// Optional: settings[...] overrides

$mysqli = require __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../helpers/json.php';
require_once __DIR__ . '/../models/AuditModel.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  seom_json(['ok' => false, 'message' => 'POST required'], 405);
}

$startUrl = trim($_POST['start_url'] ?? '');
if ($startUrl === '') {
  seom_json(['ok' => false, 'message' => 'start_url required'], 400);
}

$config = require __DIR__ . '/../config/config.php';
$defaults = $config['crawler']['default_settings'] ?? [];

// Allow limited overrides (safe)
$overrides = $_POST['settings'] ?? [];
if (!is_array($overrides)) $overrides = [];

$settings = array_merge($defaults, array_intersect_key($overrides, $defaults));

try {
  $audit = (new AuditModel($mysqli))->create($startUrl, $settings, null);
  seom_json(['ok' => true, 'audit' => $audit]);
} catch (Throwable $e) {
  seom_json(['ok' => false, 'message' => $e->getMessage()], 400);
}
