<?php
$mysqli = require __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../helpers/json.php';

$auditId = (int)($_GET['audit_id'] ?? 0);
if ($auditId <= 0) seom_json(['ok' => false, 'message' => 'Invalid audit_id'], 400);

$stmt = $mysqli->prepare('SELECT id, domain, start_url, status, pages_discovered, pages_crawled, started_at, finished_at FROM audits WHERE id = ? LIMIT 1');
$stmt->bind_param('i', $auditId);
$stmt->execute();
$res = $stmt->get_result();
if (!$res || $res->num_rows === 0) {
  seom_json(['ok' => false, 'message' => 'Audit not found'], 404);
}
$row = $res->fetch_assoc();
$stmt->close();

$pagesDiscovered = (int)($row['pages_discovered'] ?? 0);
$pagesCrawled = (int)($row['pages_crawled'] ?? 0);
$progress = $pagesDiscovered > 0 ? (int)floor(min(100, ($pagesCrawled / $pagesDiscovered) * 100)) : 0;

seom_json([
  'ok' => true,
  'audit' => $row,
  'progress_percent' => $progress,
]);
