<?php
require_once __DIR__ . '/../helpers/http.php';

class Fetcher {
  public static function fetch(string $url, array $settings): array {
    $res = seom_http_get($url, [
      'timeout_sec' => (int)($settings['timeout_sec'] ?? 15),
      'user_agent' => (string)($settings['user_agent'] ?? 'SEOMasterBot/1.0'),
      'max_redirects' => (int)($settings['max_redirects'] ?? 5),
    ]);
    return $res;
  }
}
