<?php
require_once __DIR__ . '/../helpers/http.php';
require_once __DIR__ . '/../helpers/url.php';

class Robots {
  public static function fetch(string $baseUrl, array $httpOpts = []): array {
    $robotsUrl = rtrim($baseUrl, '/') . '/robots.txt';
    $res = seom_http_get($robotsUrl, $httpOpts);
    if (($res['http_code'] ?? 0) !== 200 || !is_string($res['body'] ?? null)) {
      return ['ok' => false, 'sitemaps' => [], 'disallow' => []];
    }

    $lines = preg_split("/\r\n|\r|\n/", $res['body']);
    $sitemaps = [];
    $disallow = [];
    foreach ($lines as $line) {
      $line = trim($line);
      if ($line === '' || str_starts_with($line, '#')) continue;
      if (stripos($line, 'Sitemap:') === 0) {
        $u = trim(substr($line, 8));
        $u = seom_normalize_url($u, ['allow_query_params' => true]) ?? null;
        if ($u) $sitemaps[] = $u;
      }
      if (stripos($line, 'Disallow:') === 0) {
        $p = trim(substr($line, 9));
        if ($p !== '') $disallow[] = $p;
      }
    }

    return ['ok' => true, 'sitemaps' => array_values(array_unique($sitemaps)), 'disallow' => array_values(array_unique($disallow))];
  }
}
