<?php
require_once __DIR__ . '/../helpers/http.php';
require_once __DIR__ . '/../helpers/url.php';

class Sitemap {
  public static function fetchUrls(string $sitemapUrl, array $httpOpts = []): array {
    $res = seom_http_get($sitemapUrl, $httpOpts);
    if (($res['http_code'] ?? 0) !== 200 || !is_string($res['body'] ?? null)) {
      return ['ok' => false, 'urls' => [], 'error' => 'Could not fetch sitemap'];
    }

    libxml_use_internal_errors(true);
    $xml = simplexml_load_string($res['body']);
    libxml_clear_errors();
    if (!$xml) {
      return ['ok' => false, 'urls' => [], 'error' => 'Invalid XML'];
    }

    $urls = [];
    $name = strtolower($xml->getName());

    // sitemapindex
    if ($name === 'sitemapindex') {
      foreach ($xml->sitemap as $sm) {
        $loc = (string)($sm->loc ?? '');
        $loc = seom_normalize_url($loc);
        if ($loc) $urls[] = $loc;
      }
      return ['ok' => true, 'type' => 'index', 'urls' => array_values(array_unique($urls))];
    }

    // urlset
    if ($name === 'urlset') {
      foreach ($xml->url as $u) {
        $loc = (string)($u->loc ?? '');
        $loc = seom_normalize_url($loc);
        if ($loc) $urls[] = $loc;
      }
      return ['ok' => true, 'type' => 'urlset', 'urls' => array_values(array_unique($urls))];
    }

    return ['ok' => false, 'urls' => [], 'error' => 'Unsupported sitemap type'];
  }
}
