<?php
// cPanel Cron entry example (every 2 minutes):
// /usr/local/bin/php -q /home/USER/public_html/seomaster/app/cron/run-crawl-batch.php

$mysqli = require __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../crawler/Runner.php';

$result = Runner::runOneBatch($mysqli);

// Keep output short for cron logs
if (PHP_SAPI === 'cli') {
  echo date('Y-m-d H:i:s') . ' ' . json_encode($result, JSON_UNESCAPED_SLASHES) . PHP_EOL;
} else {
  header('Content-Type: application/json');
  echo json_encode($result, JSON_UNESCAPED_SLASHES);
}
