<?php

function seom_load_dom(string $html): ?DOMDocument {
  if ($html === '') return null;
  libxml_use_internal_errors(true);
  $dom = new DOMDocument();
  $ok = $dom->loadHTML($html, LIBXML_NOWARNING | LIBXML_NOERROR);
  libxml_clear_errors();
  return $ok ? $dom : null;
}

function seom_dom_text(?DOMNode $node): string {
  if (!$node) return '';
  $text = $node->textContent ?? '';
  $text = preg_replace('/\s+/u', ' ', $text);
  return trim($text);
}
