<?php
require_once __DIR__ . '/logger.php';

function seom_http_get(string $url, array $options = []): array {
  $timeout = (int)($options['timeout_sec'] ?? 15);
  $ua = $options['user_agent'] ?? 'SEOMasterBot/1.0';
  $maxRedirects = (int)($options['max_redirects'] ?? 5);

  $ch = curl_init();
  $headers = [];
  curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_MAXREDIRS => $maxRedirects,
    CURLOPT_TIMEOUT => $timeout,
    CURLOPT_CONNECTTIMEOUT => $timeout,
    CURLOPT_USERAGENT => $ua,
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_SSL_VERIFYHOST => 2,
    CURLOPT_HEADERFUNCTION => function($ch, $header) use (&$headers) {
      $len = strlen($header);
      $header = trim($header);
      if ($header === '' || strpos($header, ':') === false) return $len;
      [$k, $v] = explode(':', $header, 2);
      $headers[strtolower(trim($k))] = trim($v);
      return $len;
    },
  ]);

  $start = microtime(true);
  $body = curl_exec($ch);
  $elapsed = (int)round((microtime(true) - $start) * 1000);

  $err = curl_error($ch);
  $info = curl_getinfo($ch);
  curl_close($ch);

  $httpCode = (int)($info['http_code'] ?? 0);
  $finalUrl = $info['url'] ?? $url;

  return [
    'ok' => ($err === '' && $httpCode > 0),
    'error' => $err !== '' ? $err : null,
    'http_code' => $httpCode,
    'final_url' => $finalUrl,
    'content_type' => $headers['content-type'] ?? ($info['content_type'] ?? null),
    'elapsed_ms' => $elapsed,
    'bytes' => is_string($body) ? strlen($body) : 0,
    'headers' => $headers,
    'body' => is_string($body) ? $body : '',
    'redirect_count' => (int)($info['redirect_count'] ?? 0),
  ];
}
