<?php

function seom_json(array $data, int $statusCode = 200): void {
  http_response_code($statusCode);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

function seom_json_safe_decode(?string $json, bool $assoc = true) {
  if (!$json) return $assoc ? [] : null;
  $data = json_decode($json, $assoc);
  if (json_last_error() !== JSON_ERROR_NONE) return $assoc ? [] : null;
  return $data;
}

function seom_db_json(array $data): string {
  return json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}
