<?php

function seom_log(string $message, string $level = 'INFO'): void {
  $config = require __DIR__ . '/../config/config.php';
  $storage = $config['app']['storage_path'] ?? (dirname(__DIR__, 2) . '/storage');
  $dir = rtrim($storage, '/') . '/logs';
  if (!is_dir($dir)) {
    @mkdir($dir, 0755, true);
  }
  $file = $dir . '/seomaster-' . date('Y-m-d') . '.log';
  $line = sprintf("[%s] [%s] %s\n", date('Y-m-d H:i:s'), $level, $message);
  @file_put_contents($file, $line, FILE_APPEND);
}
