<?php

function seom_strip_and_normalize_text(string $html): string {
  $text = strip_tags($html);
  $text = html_entity_decode($text, ENT_QUOTES | ENT_HTML5, 'UTF-8');
  $text = mb_strtolower($text, 'UTF-8');
  $text = preg_replace('/\s+/u', ' ', $text);
  return trim($text);
}

function seom_word_count(string $text): int {
  $text = trim($text);
  if ($text === '') return 0;
  // Rough word count for Unicode text
  $words = preg_split('/\s+/u', $text);
  return is_array($words) ? count($words) : 0;
}

function seom_text_html_ratio(string $text, string $html): float {
  $htmlLen = max(1, strlen($html));
  $textLen = strlen($text);
  return round(($textLen / $htmlLen) * 100, 2);
}
