<?php

class PageModel {
  private mysqli $db;
  public function __construct(mysqli $db) { $this->db = $db; }

  public function upsert(int $auditId, int $urlId, array $data): void {
    $sql = "INSERT INTO audit_pages (
      audit_id, url_id,
      title, title_len,
      meta_description, meta_description_len,
      canonical, robots_meta,
      h1, headings_json, links_json, images_json, schema_json, og_json, twitter_json,
      lang, viewport_meta,
      word_count, text_html_ratio,
      content_hash,
      created_at, updated_at
    ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())
    ON DUPLICATE KEY UPDATE
      title=VALUES(title), title_len=VALUES(title_len),
      meta_description=VALUES(meta_description), meta_description_len=VALUES(meta_description_len),
      canonical=VALUES(canonical), robots_meta=VALUES(robots_meta),
      h1=VALUES(h1), headings_json=VALUES(headings_json), links_json=VALUES(links_json), images_json=VALUES(images_json), schema_json=VALUES(schema_json), og_json=VALUES(og_json), twitter_json=VALUES(twitter_json),
      lang=VALUES(lang), viewport_meta=VALUES(viewport_meta),
      word_count=VALUES(word_count), text_html_ratio=VALUES(text_html_ratio),
      content_hash=VALUES(content_hash),
      updated_at=NOW()";

    $stmt = $this->db->prepare($sql);
    if (!$stmt) throw new Exception('DB prepare failed (pages upsert)');

    $title = $data['title'] ?? null;
    $titleLen = $data['title_len'] ?? null;
    $meta = $data['meta_description'] ?? null;
    $metaLen = $data['meta_description_len'] ?? null;
    $canonical = $data['canonical'] ?? null;
    $robots = $data['robots_meta'] ?? null;
    $h1 = $data['h1'] ?? null;

    $headingsJson = $data['headings_json'] ?? null;
    $linksJson = $data['links_json'] ?? null;
    $imagesJson = $data['images_json'] ?? null;
    $schemaJson = $data['schema_json'] ?? null;
    $ogJson = $data['og_json'] ?? null;
    $twitterJson = $data['twitter_json'] ?? null;

    $lang = $data['lang'] ?? null;
    $viewport = $data['viewport_meta'] ?? null;

    $wordCount = $data['word_count'] ?? null;
    $ratio = $data['text_html_ratio'] ?? null;
    $hash = $data['content_hash'] ?? null;

    $stmt->bind_param(
      'ii' . 'ss' . 'ss' . 'ssss' . 'ssssss' . 'ss' . 'id' . 's',
      $auditId, $urlId,
      $title, $titleLen,
      $meta, $metaLen,
      $canonical, $robots,
      $h1, $headingsJson,
      $linksJson, $imagesJson, $schemaJson, $ogJson, $twitterJson,
      $lang, $viewport,
      $wordCount, $ratio,
      $hash
    );

    $stmt->execute();
    $stmt->close();
  }
}
