-- SEO Master (SEO Master Cyber Bot) - Phase 1
-- Database Schema (MySQL 5.7+/8.0+ recommended)
-- Engine: InnoDB | Charset: utf8mb4

CREATE TABLE IF NOT EXISTS audits (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  user_id BIGINT UNSIGNED NULL,
  domain VARCHAR(255) NOT NULL,
  start_url VARCHAR(500) NOT NULL,
  status ENUM('queued','discovering','running','evaluating','done','failed') NOT NULL DEFAULT 'queued',
  settings JSON NOT NULL,
  started_at DATETIME NULL,
  finished_at DATETIME NULL,
  pages_discovered INT UNSIGNED NOT NULL DEFAULT 0,
  pages_crawled INT UNSIGNED NOT NULL DEFAULT 0,
  overall_score TINYINT UNSIGNED NOT NULL DEFAULT 0,
  score_breakdown JSON NULL,
  summary JSON NULL,
  error_message VARCHAR(500) NULL,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  INDEX idx_domain (domain),
  INDEX idx_status (status),
  INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS audit_urls (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  audit_id BIGINT UNSIGNED NOT NULL,
  url VARCHAR(1000) NOT NULL,
  url_hash CHAR(40) NOT NULL,
  depth SMALLINT UNSIGNED NOT NULL DEFAULT 0,
  discovered_from VARCHAR(1000) NULL,
  source ENUM('sitemap','internal','seed','manual') NOT NULL DEFAULT 'seed',
  state ENUM('queued','fetching','fetched','failed','skipped') NOT NULL DEFAULT 'queued',
  http_code SMALLINT UNSIGNED NULL,
  final_url VARCHAR(1000) NULL,
  redirect_hops SMALLINT UNSIGNED NULL,
  content_type VARCHAR(100) NULL,
  load_time_ms INT UNSIGNED NULL,
  bytes INT UNSIGNED NULL,
  last_error VARCHAR(255) NULL,
  fetched_at DATETIME NULL,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  UNIQUE KEY uniq_audit_urlhash (audit_id, url_hash),
  INDEX idx_audit_state (audit_id, state),
  CONSTRAINT fk_urls_audit FOREIGN KEY (audit_id) REFERENCES audits(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS audit_pages (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  audit_id BIGINT UNSIGNED NOT NULL,
  url_id BIGINT UNSIGNED NOT NULL,

  title VARCHAR(500) NULL,
  title_len SMALLINT UNSIGNED NULL,
  meta_description VARCHAR(1000) NULL,
  meta_description_len SMALLINT UNSIGNED NULL,

  canonical VARCHAR(1000) NULL,
  robots_meta VARCHAR(255) NULL,

  h1 VARCHAR(500) NULL,
  headings_json JSON NULL,
  links_json JSON NULL,
  images_json JSON NULL,
  schema_json JSON NULL,
  og_json JSON NULL,
  twitter_json JSON NULL,

  lang VARCHAR(25) NULL,
  viewport_meta VARCHAR(255) NULL,

  word_count INT UNSIGNED NULL,
  text_html_ratio DECIMAL(6,2) NULL,

  content_hash CHAR(40) NULL,

  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,

  UNIQUE KEY uniq_audit_url (audit_id, url_id),
  INDEX idx_audit (audit_id),
  CONSTRAINT fk_pages_audit FOREIGN KEY (audit_id) REFERENCES audits(id) ON DELETE CASCADE,
  CONSTRAINT fk_pages_url FOREIGN KEY (url_id) REFERENCES audit_urls(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
